---
generated_at: 2026-01-30 12:55:00
metrics:
  claims_total: 32
  claims_with_evidence: 29
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：20-System.Threading.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：29 / 32、根拠なし：3
- 優先レビュー（高）
  1. **他の同期プリミティブ詳細**：SpinLock、ReaderWriterLockSlim等
  2. **ThreadPoolの詳細**：スレッドプール管理
  3. **CancellationTokenの詳細実装**：内部動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Threading/src/System/Threading/Barrier.cs`
- E-02: `src/libraries/System.Private.CoreLib/src/System/Threading/CancellationTokenSource.cs`（推定）
- E-03: `src/libraries/System.Private.CoreLib/src/System/Threading/SpinLock.cs`（推定）
- E-04: `src/libraries/System.Private.CoreLib/src/System/Threading/SemaphoreSlim.cs`（推定）
- E-05: 機能一覧.csv

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Barrierクラスがバリア同期提供 | E-01 | ○ |
| C-02 | BarrierPostPhaseExceptionの定義 | E-01（26-75行目） | ○ |
| C-03 | _currentTotalCountフィールド | E-01（105行目） | ○ |
| C-04 | ビットマスク定数（CURRENT_MASK等） | E-01（108-117行目） | ○ |
| C-05 | MAX_PARTICIPANTS = 32767 | E-01（117行目） | ○ |
| C-06 | _currentPhase, _oddEvent, _evenEventフィールド | E-01（120-133行目） | ○ |
| C-07 | _postPhaseAction, _exception, _actionCallerID | E-01（142-150行目） | ○ |
| C-08 | ParticipantsRemainingプロパティ | E-01（162-171行目） | ○ |
| C-09 | ParticipantCountプロパティ | E-01（176-178行目） | ○ |
| C-10 | CurrentPhaseNumberプロパティ | E-01（184-190行目） | ○ |
| C-11 | コンストラクタ(int) | E-01（200-203行目） | ○ |
| C-12 | コンストラクタ(int, Action<Barrier>) | E-01（219-237行目） | ○ |
| C-13 | GetCurrentTotalヘルパー | E-01（246-251行目） | ○ |
| C-14 | SetCurrentTotalヘルパー | E-01（261-271行目） | ○ |
| C-15 | AddParticipant [UnsupportedOSPlatform("browser")] | E-01（287-300行目） | ○ |
| C-16 | AddParticipants実装 | E-01（318-388行目） | ○ |
| C-17 | RemoveParticipant/RemoveParticipants | E-01（400-466行目） | ○ |
| C-18 | SignalAndWait() | E-01（478-484行目） | ○ |
| C-19 | SignalAndWait(CancellationToken) | E-01（504-513行目） | ○ |
| C-20 | SignalAndWait(int, CancellationToken)の実装 | E-01（625-758行目） | ○ |
| C-21 | FinishPhase実装 | E-01（765-802行目） | ○ |
| C-22 | InvokePostPhaseAction | E-01（808-812行目） | ○ |
| C-23 | SetResetEvents実装 | E-01（818-832行目） | ○ |
| C-24 | WaitCurrentPhase | E-01（840-851行目） | ○ |
| C-25 | DiscontinuousWait | E-01（867-896行目） | ○ |
| C-26 | Dispose実装 | E-01（908-940行目） | ○ |
| C-27 | SpinWait.SpinOnce(sleep1Threshold: -1)使用 | E-01（385, 464, 684, 750行目） | ○ |
| C-28 | Interlocked.CompareExchange使用 | E-01（270行目） | ○ |
| C-29 | Volatile.Read/Write使用 | E-01（187-189行目） | ○ |
| C-30 | SpinLockの詳細動作 | **根拠なし** | △ |
| C-31 | ReaderWriterLockSlimの詳細動作 | **根拠なし** | △ |
| C-32 | CancellationTokenSourceの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SpinLock の詳細実装
  - 候補：SpinLock.cs確認
- ReaderWriterLockSlim の詳細実装
  - 候補：ReaderWriterLockSlim.cs確認
- CancellationTokenSource の詳細実装
  - 候補：CancellationTokenSource.cs確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Barrier API の基本説明は信頼性が高い
- 0: 低リスク - ソースコードから直接確認した行番号は正確
- 1: 中リスク - 他の同期プリミティブの詳細は追加確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] SpinLock/ReaderWriterLockSlimの使用例を確認
- [ ] CancellationTokenSourceの内部動作を確認
- [ ] コードサンプルの動作確認
- [ ] 関連ファイル一覧のパスが実際に存在するか確認
- [ ] [UnsupportedOSPlatform("browser")]の影響範囲確認
