---
generated_at: 2026-01-30 10:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：22-System.Threading.Tasks.Dataflow

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の定量的指標**：具体的なベンチマーク結果なし
  2. **NuGetパッケージ名の正確性**：パッケージ構成の変更有無を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Threading.Tasks.Dataflow/src/Base/IDataflowBlock.cs`
- E-02: `src/libraries/System.Threading.Tasks.Dataflow/src/Base/DataflowBlockOptions.cs`
- E-03: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/BufferBlock.cs`
- E-04: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/ActionBlock.cs`
- E-05: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/TransformBlock.cs`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IDataflowBlockがCompletion、Complete、Faultメソッドを定義 | E-01 (21-29行目) | ○ |
| C-02 | DataflowBlockOptionsにTaskScheduler、MaxMessagesPerTask、BoundedCapacity等がある | E-02 (68-79行目) | ○ |
| C-03 | ExecutionDataflowBlockOptionsにMaxDegreeOfParallelism、SingleProducerConstrainedがある | E-02 (277-280行目) | ○ |
| C-04 | GroupingDataflowBlockOptionsにGreedy、MaxNumberOfGroupsがある | E-02 (409-412行目) | ○ |
| C-05 | BufferBlockがSourceCoreを使用 | E-03 (28行目) | ○ |
| C-06 | BufferBlockのOfferMessageでメッセージ受け入れ判定 | E-03 (88-141行目) | ○ |
| C-07 | ActionBlockがTargetCoreまたはSpscTargetCoreを使用 | E-04 (28-30行目) | ○ |
| C-08 | ActionBlockでSingleProducerConstrained時にSpscTargetCoreを使用 | E-04 (80-90行目) | ○ |
| C-09 | TransformBlockがTargetCore、ReorderingBuffer、SourceCoreを保持 | E-05 (28-32行目) | ○ |
| C-10 | TransformBlockで並列実行時にReorderingBufferで順序保証 | E-05 (115-118行目) | ○ |
| C-11 | EnsureOrderedオプションがデフォルトtrue | E-02 (79行目) | ○ |
| C-12 | MaxDegreeOfParallelismのデフォルトが1 | E-02 (278行目) | ○ |
| C-13 | BoundedCapacityのデフォルトがUnbounded | E-02 (75行目) | ○ |
| C-14 | Unbounded定数が-1 | E-02 (66行目) | ○ |
| C-15 | ターゲット完了時にソースへ伝播 | E-05 (140-145行目) | ○ |
| C-16 | デリゲート内の協調キャンセルは無視される | E-04 (138行目), E-05 (184行目) | ○ |
| C-17 | ProcessMessageで同期デリゲート実行 | E-04 (128-146行目), E-05 (171-218行目) | ○ |
| C-18 | ProcessMessageWithTaskで非同期デリゲート実行 | E-04 (151-192行目), E-05 (223-263行目) | ○ |
| C-19 | InputCountプロパティが存在 | E-04 (289-292行目), E-05 (359行目) | ○ |
| C-20 | OutputCountプロパティが存在 | E-03 (192行目), E-05 (362行目) | ○ |
| C-21 | LinkToメソッドでブロック間接続 | E-03 (183行目), E-05 (341-344行目) | ○ |
| C-22 | Postメソッドが同期的に即座に結果を返す | E-04 (267-278行目) | ○ |
| C-23 | TryReceiveでフィルタ付き受信が可能 | E-03 (186行目), E-05 (347-350行目) | ○ |
| C-24 | FaultメソッドでブロックをFault状態にできる | E-03 (147-152行目), E-04 (232-245行目) | ○ |
| C-25 | DataflowEtwProviderでETWログ出力 | E-03 (80-84行目), E-04 (116-120行目) | ○ |
| C-26 | SupportsParallelExecutionでMaxDegreeOfParallelism > 1を判定 | E-02 (328行目) | ○ |
| C-27 | パフォーマンス最適化の具体的な数値 | **根拠なし** | △ |
| C-28 | NuGetパッケージ名がSystem.Threading.Tasks.Dataflow | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の定量的指標**
  - 理由: ソースコードにベンチマーク結果や性能数値の記載なし
  - 候補: ベンチマークテスト / 公式ドキュメント / パフォーマンスレポート

- **NuGetパッケージ構成**
  - 理由: .csprojファイルやビルド構成を確認していない
  - 候補: System.Threading.Tasks.Dataflow.csproj / NuGet.org

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ブロック種別、インターフェース、オプション設定（ソースコードから直接確認可能）
- **0: 低リスク** - 処理フロー、データフロー図（実装から論理的に導出可能）
- **1: 中リスク** - パフォーマンス要件（定性的記述は正確だが定量的根拠なし）
- **1: 中リスク** - 備考のパッケージ情報（最新のパッケージ構成を要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] DataflowBlockOptions各プロパティのデフォルト値が正確か確認
- [ ] ブロック種別（Buffer、Action、Transform等）の説明が正確か確認
- [ ] EnsureOrderedとReorderingBufferの関係が正しく記述されているか確認
- [ ] コードリーディングガイドの行番号が最新のソースと一致しているか確認
- [ ] パフォーマンス要件セクションに定量的指標を追記するか判断
