---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 21
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：23-System.Numerics.Tensors

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：21 / 24、根拠なし：3
- 優先レビュー（高）
  1. **SIMD最適化の詳細**：具体的なコードパスの確認が必要
  2. **.NETバージョン対応状況**：公式ドキュメントでの確認が必要
  3. **ONNX Runtime/ML.NET相互運用**：実装の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Numerics.Tensors/src/System/Numerics/Tensors/netcore/Tensor_1.cs`
- E-02: `src/libraries/System.Numerics.Tensors/src/System/Numerics/Tensors/netcore/TensorPrimitives.Dot.cs`
- E-03: `src/libraries/System.Numerics.Tensors/src/System/Numerics/Tensors/netcore/TensorShape.cs`
- E-04: `src/libraries/System.Numerics.Tensors/src/System/Buffers/NIndex.cs`
- E-05: `src/libraries/System.Numerics.Tensors/src/System/Buffers/NRange.cs`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Tensor<T>がITensor<Tensor<T>,T>を実装 | E-01 (18行目) | ○ |
| C-02 | Tensor<T>が内部でTensorShape、T[]、startを保持 | E-01 (23-25行目) | ○ |
| C-03 | Tensor<T>.Emptyが空テンソルを提供 | E-01 (21行目) | ○ |
| C-04 | インデクサーでnint/NIndexアクセスが可能 | E-01 (81-90行目) | ○ |
| C-05 | NRangeでスライスアクセスが可能 | E-01 (93-97行目) | ○ |
| C-06 | FlattenedLength、IsDense、IsEmpty等のプロパティがある | E-01 (100-109行目) | ○ |
| C-07 | Lengths、Rank、Stridesプロパティがある | E-01 (114-121行目) | ○ |
| C-08 | 配列からTensor<T>への暗黙変換がある | E-01 (126行目) | ○ |
| C-09 | Tensor<T>からTensorSpan<T>への暗黙変換がある | E-01 (131行目) | ○ |
| C-10 | AsTensorSpanメソッドがある | E-01 (149行目) | ○ |
| C-11 | AsReadOnlyTensorSpanメソッドがある | E-01 (137行目) | ○ |
| C-12 | Clear、CopyTo、Fill等のメソッドがある | E-01 (160-173行目) | ○ |
| C-13 | GetDimensionSpanメソッドがある | E-01 (185行目) | ○ |
| C-14 | GetPinnableReferenceメソッドがある | E-01 (191-198行目) | ○ |
| C-15 | TensorPrimitives.DotがBLAS1のdotに対応 | E-02 (21行目) | ○ |
| C-16 | Dot<T>がジェネリック型制約を使用 | E-02 (32行目) | ○ |
| C-17 | DotがMultiplyOperatorとAddOperatorでAggregate | E-02 (33行目) | ○ |
| C-18 | NaN入力はNaN結果を伝播 | E-02 (24行目) | ○ |
| C-19 | NIndexがネイティブサイズインデックスを提供 | E-04 | ○ |
| C-20 | NRangeがネイティブサイズ範囲を提供 | E-05 | ○ |
| C-21 | TensorShapeがLengths、Stridesを管理 | E-03 | ○ |
| C-22 | AVX512/AVX2/SSE/ARM NEONによる自動ベクトル化 | **根拠なし** | △ |
| C-23 | .NET 8以降でTensor<T>クラスが利用可能 | **根拠なし** | △ |
| C-24 | ONNX Runtime/ML.NETとの相互運用に適している | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **SIMD最適化の詳細**
  - 理由: TensorPrimitives.Helpers.csの詳細コードを確認していない
  - 候補: TensorPrimitives.Helpers.cs / System.Runtime.Intrinsicsの使用箇所

- **.NETバージョン対応状況**
  - 理由: csprojファイルやTargetFrameworkを確認していない
  - 候補: System.Numerics.Tensors.csproj / 公式ドキュメント

- **外部ライブラリとの相互運用**
  - 理由: ONNX Runtime/ML.NETとの統合コードを確認していない
  - 候補: サンプルコード / 公式ドキュメント / NuGetパッケージ依存関係

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Tensor<T>の構造、プロパティ、メソッド（ソースコードから直接確認可能）
- **0: 低リスク** - TensorPrimitives.Dotの実装（ソースコードから直接確認可能）
- **1: 中リスク** - SIMD最適化の詳細（ヘルパーコードの詳細確認が必要）
- **2: 高リスク** - .NETバージョン対応、外部ライブラリ相互運用（公式ドキュメント確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] Tensor<T>のプロパティとメソッドが正確に記述されているか確認
- [ ] TensorPrimitives演算の説明が正確か確認
- [ ] SIMD最適化に関する記述を詳細コードで検証
- [ ] .NET対応バージョンを公式ドキュメントで確認
- [ ] コードリーディングガイドの行番号が最新のソースと一致しているか確認
