---
generated_at: 2026-01-30 10:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 23
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：24-System.Reflection.Emit

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：23 / 26、根拠なし：3
- 優先レビュー（高）
  1. **PersistedAssemblyBuilderの.NET 9対応**：バージョン対応の確認が必要
  2. **DynamicMethodの詳細**：別ライブラリ（System.Reflection.Emit.Lightweight）との関係
  3. **セキュリティ考慮事項**：PartialTrust環境の記述は.NET Framework時代

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/TypeBuilderImpl.cs`
- E-02: `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ILGeneratorImpl.cs`
- E-03: `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/MethodBuilderImpl.cs`
- E-04: `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/ModuleBuilderImpl.cs`
- E-05: `src/libraries/System.Reflection.Emit/src/System/Reflection/Emit/PersistedAssemblyBuilder.cs`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TypeBuilderImplがModuleBuilderImplへの参照を持つ | E-01 (15行目) | ○ |
| C-02 | TypeBuilderImplが名前、名前空間、属性、親型を保持 | E-01 (16-22行目) | ○ |
| C-03 | TypeBuilderImplがメソッド、フィールド、コンストラクタリストを持つ | E-01 (34-36行目) | ○ |
| C-04 | グローバル型は"<Module>"という名前 | E-01 (46行目) | ○ |
| C-05 | コンストラクタでフルネームからnamespace抽出 | E-01 (65-70行目) | ○ |
| C-06 | AddInterfaceImplementationCoreでインターフェース追加 | E-01 (89-95行目) | ○ |
| C-07 | CreateTypeInfoCoreでデフォルトコンストラクタ自動生成 | E-01 (114-118行目) | ○ |
| C-08 | 抽象メソッドはボディを持てない検証 | E-01 (142-146行目) | ○ |
| C-09 | 非抽象クラスに抽象メソッドは不可 | E-01 (133-139行目) | ○ |
| C-10 | ILGeneratorImplがBlobBuilder、InstructionEncoderを使用 | E-02 (18-19行目) | ○ |
| C-11 | ILGeneratorImplがスタック深度を追跡 | E-02 (24-26行目) | ○ |
| C-12 | ILGeneratorImplがラベルテーブルを持つ | E-02 (31行目) | ○ |
| C-13 | ILGeneratorImplが例外ブロックリストを持つ | E-02 (33-34行目) | ○ |
| C-14 | AddExceptionBlocksでCatch/Filter/Fault/Finally領域を登録 | E-02 (58-82行目) | ○ |
| C-15 | ILOffsetプロパティで現在のオフセット取得 | E-02 (84行目) | ○ |
| C-16 | BeginCatchBlockで例外キャッチブロック開始 | E-02 (86-129行目) | ○ |
| C-17 | キャッチブロック開始時にスタック深度を1に設定 | E-02 (127行目) | ○ |
| C-18 | GetMaxStackで最大スタック深度を取得 | E-02 (49行目) | ○ |
| C-19 | LocalCountでローカル変数数を取得 | E-02 (54行目) | ○ |
| C-20 | DocumentToSequencePointsでシーケンスポイント管理 | E-02 (35行目, 56行目) | ○ |
| C-21 | _isCreatedフラグでCreateType済みを追跡 | E-01 (26行目, 101行目) | ○ |
| C-22 | ThrowIfCreatedでCreateType済みの変更を防止 | E-01 (91行目) | ○ |
| C-23 | TypeDefinitionHandleでメタデータハンドルを保持 | E-01 (29行目) | ○ |
| C-24 | PersistedAssemblyBuilder（.NET 9+）でPDB生成サポート | **根拠なし** | △ |
| C-25 | RunAndCollectモードでアンロード可能 | **根拠なし** | △ |
| C-26 | DynamicMethodがメモリ効率が良い | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **PersistedAssemblyBuilderの.NETバージョン対応**
  - 理由: csprojファイルやTargetFrameworkを確認していない
  - 候補: System.Reflection.Emit.csproj / 公式ドキュメント

- **RunAndCollectモードの詳細**
  - 理由: AssemblyBuilderAccessフラグの使用箇所を確認していない
  - 候補: RuntimeAssemblyBuilder / 公式ドキュメント

- **DynamicMethodの詳細**
  - 理由: System.Reflection.Emit.Lightweightパッケージを確認していない
  - 候補: DynamicMethod.cs / 別ライブラリ

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - TypeBuilderImpl、ILGeneratorImplの構造と内部フィールド（ソースコードから直接確認可能）
- **0: 低リスク** - CreateType、メソッド検証の処理フロー（ソースコードから直接確認可能）
- **1: 中リスク** - PersistedAssemblyBuilderのPDB対応（公式ドキュメント確認が必要）
- **2: 高リスク** - .NETバージョン対応、DynamicMethod（別ソース確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] TypeBuilderImplの内部構造が正確に記述されているか確認
- [ ] ILGeneratorImplのスタック追跡・例外ブロック処理が正確か確認
- [ ] CreateTypeの自動生成ルール（デフォルトコンストラクタ等）が正確か確認
- [ ] PersistedAssemblyBuilderの.NETバージョン対応を公式ドキュメントで確認
- [ ] コードリーディングガイドの行番号が最新のソースと一致しているか確認
