---
generated_at: 2026-01-30 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：25-System.Reflection.Metadata

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **.NET Standard対応バージョン**：公式ドキュメントでの確認が必要
  2. **圧縮整数デコードの詳細**：BlobReader内部実装の詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Reflection.Metadata/src/System/Reflection/Metadata/MetadataReader.cs`
- E-02: `src/libraries/System.Reflection.Metadata/src/System/Reflection/Metadata/BlobReader.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MetadataReaderがNamespaceCacheとMemoryBlockを保持 | E-01 (19-20行目) | ○ |
| C-02 | MetadataReaderがMetadataReaderOptionsを保持 | E-01 (28行目) | ○ |
| C-03 | コンストラクタでlengthが負の場合ArgumentOutOfRangeException | E-01 (79-82行目) | ○ |
| C-04 | コンストラクタでmetadataがnullの場合ArgumentNullException | E-01 (84-87行目) | ○ |
| C-05 | utf8Decoderのエンコーディングが非UTF8の場合InvalidArgument | E-01 (91-94行目) | ○ |
| C-06 | MemoryBlockを作成してBlockフィールドに設定 | E-01 (96行目) | ○ |
| C-07 | BlobReaderでメタデータヘッダを読み取る | E-01 (102-103行目) | ○ |
| C-08 | ReadStreamHeadersでストリームヘッダを読み取る | E-01 (105行目) | ○ |
| C-09 | InitializeStreamReadersでストリームリーダーを初期化 | E-01 (108行目) | ○ |
| C-10 | ReadMetadataTableHeaderでテーブルヘッダを読み取る | E-01 (123行目) | ○ |
| C-11 | InitializeTableReadersでテーブルリーダーを初期化 | E-01 (125行目) | ○ |
| C-12 | NamespaceCacheを初期化 | E-01 (140行目) | ○ |
| C-13 | ModuleTable.NumberOfRowsが1未満の場合BadImageFormatException | E-01 (134-137行目) | ○ |
| C-14 | BlobReaderがMemoryBlock、ポインタを保持 | E-02 (17-22行目) | ○ |
| C-15 | BlobReaderコンストラクタでMemoryBlock.CreateChecked呼び出し | E-02 (32-36行目) | ○ |
| C-16 | StartPointer、CurrentPointer、Lengthプロパティがある | E-02 (76-86行目) | ○ |
| C-17 | Offsetプロパティでget/set可能 | E-02 (92-100行目) | ○ |
| C-18 | InvalidCompressedInteger定数がint.MaxValue | E-02 (15行目) | ○ |
| C-19 | リトルエンディアンプラットフォームのみサポート | E-02 (31行目) | ○ |
| C-20 | ECMA-335 CLI仕様に準拠 | E-01 (15行目) | ○ |
| C-21 | .NET Standard 1.1以降で利用可能 | **根拠なし** | △ |
| C-22 | 圧縮整数デコードの詳細アルゴリズム | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **.NET Standard対応バージョン**
  - 理由: csprojファイルやTargetFrameworkを確認していない
  - 候補: System.Reflection.Metadata.csproj / NuGet.org / 公式ドキュメント

- **圧縮整数デコードの詳細**
  - 理由: BlobReaderの圧縮整数読み取りメソッドを詳細確認していない
  - 候補: BlobReader.cs内のReadCompressedIntegerメソッド

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - MetadataReader構造、コンストラクタ処理（ソースコードから直接確認可能）
- **0: 低リスク** - BlobReader構造、プロパティ（ソースコードから直接確認可能）
- **1: 中リスク** - 圧縮整数デコードのアルゴリズム詳細（ECMA-335仕様参照が必要）
- **1: 中リスク** - .NET Standard対応バージョン（公式ドキュメント確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] MetadataReaderのコンストラクタ処理が正確に記述されているか確認
- [ ] BlobReaderのプロパティと使用方法が正確か確認
- [ ] ECMA-335仕様への準拠記述が正確か確認
- [ ] .NET Standard対応バージョンを公式ドキュメントで確認
- [ ] コードリーディングガイドの行番号が最新のソースと一致しているか確認
