---
generated_at: 2026-01-30 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 17
  claims_without_evidence: 3
confidence_derived: 0.85
---

# 根拠レポート：26-System.Data.Common

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：17 / 20、根拠なし：3
- 優先レビュー（高）
  1. **DbBatchの.NET 6対応**：バージョン確認が必要
  2. **接続プールの詳細**：プロバイダー実装依存
  3. **デフォルトタイムアウト値**：ADP定数の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/System.Data.Common/src/System/Data/Common/DbConnection.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DbConnectionがIDbConnection、IAsyncDisposableを実装 | E-01 (11行目) | ○ |
| C-02 | ConnectionString抽象プロパティがある | E-01 (28行目) | ○ |
| C-03 | ConnectionTimeoutのデフォルト値がADP.DefaultConnectionTimeout | E-01 (30行目) | ○ |
| C-04 | Database抽象プロパティがある | E-01 (32行目) | ○ |
| C-05 | DataSource抽象プロパティがある | E-01 (34行目) | ○ |
| C-06 | DbProviderFactory保護プロパティがある | E-01 (39行目) | ○ |
| C-07 | State抽象プロパティがある | E-01 (47行目) | ○ |
| C-08 | StateChangeイベントがある | E-01 (49行目) | ○ |
| C-09 | BeginDbTransaction抽象メソッドがある | E-01 (51行目) | ○ |
| C-10 | BeginTransaction()がBeginDbTransactionを呼び出す | E-01 (53-54行目) | ○ |
| C-11 | BeginDbTransactionAsyncでキャンセルチェック | E-01 (67-72行目) | ○ |
| C-12 | IDbConnection.BeginTransaction明示実装 | E-01 (61-65行目) | ○ |
| C-13 | _suppressStateChangeForReconnectionフィールドがある | E-01 (14行目) | ○ |
| C-14 | SettingsBindableAttribute付きConnectionString | E-01 (22行目) | ○ |
| C-15 | AllowNull属性付きConnectionString | E-01 (27行目) | ○ |
| C-16 | ServerVersion抽象プロパティ | E-01 (44行目) | ○ |
| C-17 | BrowsableAttribute(false)付きプロパティ | E-01 (43行目, 46行目) | ○ |
| C-18 | DbBatchが.NET 6以降で利用可能 | **根拠なし** | △ |
| C-19 | 接続プールの動作詳細 | **根拠なし** | △ |
| C-20 | ADP.DefaultConnectionTimeoutの値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **DbBatchの.NETバージョン対応**
  - 理由: DbBatch.csの詳細とTargetFrameworkを確認していない
  - 候補: DbBatch.cs / System.Data.Common.csproj

- **接続プールの詳細**
  - 理由: 接続プールはプロバイダー実装に依存
  - 候補: 各プロバイダーのドキュメント

- **ADP定数の値**
  - 理由: ADPクラスの詳細を確認していない
  - 候補: AdapterUtil.Common.cs

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - DbConnection構造、プロパティ、メソッド（ソースコードから直接確認可能）
- **1: 中リスク** - DbBatchの.NET対応バージョン（公式ドキュメント確認が必要）
- **1: 中リスク** - 接続プールの詳細（プロバイダー依存）

## 6) レビュアーチェックリスト（最小）
- [ ] DbConnectionのプロパティとメソッドが正確に記述されているか確認
- [ ] トランザクション処理の説明が正確か確認
- [ ] DbBatchの.NETバージョン対応を公式ドキュメントで確認
- [ ] コードリーディングガイドの行番号が最新のソースと一致しているか確認
