---
generated_at: 2026-01-30 11:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：29-System.Xml.XDocument

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **XPath統合の詳細**：CreateNavigatorメソッドの実装確認が必要
  2. **.NET 3.5導入の確認**：公式ドキュメント確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XDocument.cs` (27-155行目)
- E-02: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XDocument.cs` (186-304行目、521-606行目)
- E-03: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XElement.cs` (36-385行目)
- E-04: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XContainer.cs` (22-419行目)
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XDocumentがXContainerを継承 | E-01 (27行目) | ○ |
| C-02 | _declarationフィールドが存在 | E-01 (29行目) | ○ |
| C-03 | Declarationプロパティが存在 | E-01 (115-119行目) | ○ |
| C-04 | DocumentTypeプロパティが存在 | E-01 (124-130行目) | ○ |
| C-05 | NodeTypeがXmlNodeType.Documentを返す | E-01 (138-144行目) | ○ |
| C-06 | Rootプロパティが存在 | E-01 (149-155行目) | ○ |
| C-07 | Load(uri)メソッドが存在 | E-02 (186-189行目) | ○ |
| C-08 | LoadAsync非同期メソッドが存在 | E-02 (294-304行目) | ○ |
| C-09 | Parseメソッドが存在 | E-02 (521-524行目) | ○ |
| C-10 | Saveメソッドが存在 | E-02 (574-606行目) | ○ |
| C-11 | XElementがXContainerとIXmlSerializableを実装 | E-03 (36行目) | ○ |
| C-12 | name、lastAttrフィールドが存在 | E-03 (49-50行目) | ○ |
| C-13 | FirstAttribute/HasAttributesプロパティが存在 | E-03 (215-226行目) | ○ |
| C-14 | Attribute(name)メソッドが存在 | E-03 (373-385行目) | ○ |
| C-15 | XContainerにcontentフィールドが存在 | E-04 (24行目) | ○ |
| C-16 | FirstNode/LastNodeプロパティが存在 | E-04 (53-82行目) | ○ |
| C-17 | Add(content)メソッドが存在 | E-04 (135-180行目) | ○ |
| C-18 | Descendants()メソッドが存在 | E-04 (267-270行目) | ○ |
| C-19 | Elements()メソッドが存在 | E-04 (318-321行目) | ○ |
| C-20 | RemoveNodes()メソッドが存在 | E-04 (367-419行目) | ○ |
| C-21 | .NET 3.5で導入 | **根拠なし** | △ |
| C-22 | XPath統合（CreateNavigator） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **.NET 3.5導入の確認**
  - 理由: ソースコードからはバージョン履歴を確認できない
  - 候補: 公式ドキュメント / リリースノート

- **XPath統合の詳細**
  - 理由: CreateNavigatorメソッドの実装詳細を確認していない
  - 候補: Extensions.cs / XPathExtensions

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - クラス構造、プロパティ、メソッド（ソースコードから直接確認可能）
- **0: 低リスク** - 非同期メソッド（LoadAsync、SaveAsync）の存在
- **1: 中リスク** - .NETバージョン履歴（公式ドキュメント確認が必要）
- **1: 中リスク** - XPath統合の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] XDocument/XElement/XContainerのクラス階層が正確か確認
- [ ] Load/Parse/Saveの動作説明が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースと一致しているか確認
- [ ] .NET 3.5導入を公式ドキュメントで確認
- [ ] XPath統合（CreateNavigator）の詳細を確認
