---
generated_at: 2026-01-30 12:25:00
metrics:
  claims_total: 24
  claims_with_evidence: 21
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：3-NativeAOT.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：21 / 24、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス数値（起動時間1/10〜1/100）**：ベンチマーク根拠確認推奨
  2. **メモリ使用量50%削減**：測定データ根拠確認推奨
  3. **IL3000-IL3099エラーコード範囲**：公式ドキュメント照合推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/coreclr/nativeaot/Bootstrap/main.cpp` - ブートストラップコード
- E-02: `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/CompilerHelpers/StartupCode/StartupCodeHelpers.Extensions.cs` - スタートアップ処理
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `src/coreclr/nativeaot/Bootstrap/dllmain/dllmain.cpp` - DLLエントリーポイント（参照パス確認）
- E-05: `src/coreclr/nativeaot/System.Private.CoreLib/src/Internal/Runtime/Augments/RuntimeAugments.cs` - ランタイム拡張（参照パス確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NativeAOTはネイティブコードへの事前コンパイル機能 | E-03 | ○ |
| C-02 | スタンドアロン実行ファイル生成をサポート | E-03 | ○ |
| C-03 | .modules$A〜.modules$Zセクションでモジュール境界定義 | E-01 (23-29行目) | ○ |
| C-04 | ReadyToRunデータポインタの配置 | E-01 (32-38行目コメント) | ○ |
| C-05 | Unboxingスタブの.unbox$A〜.unbox$Zセクション | E-01 (40-44行目) | ○ |
| C-06 | /merge:.modules=.rdataディレクティブ | E-01 (38行目) | ○ |
| C-07 | /merge:.unbox=.textディレクティブ | E-01 (44行目) | ○ |
| C-08 | macOS用section$start$__DATA$__modules定義 | E-01 (75-76行目) | ○ |
| C-09 | GetLoadedModules()でモジュール取得 | E-02 (20-21行目) | ○ |
| C-10 | InitializeCommandLineArgsW()でWindows引数初期化 | E-02 (23-31行目) | ○ |
| C-11 | InitializeCommandLineArgs()でUnix引数初期化 | E-02 (33-41行目) | ○ |
| C-12 | GetMainMethodArguments()でMain引数抽出 | E-02 (43-56行目) | ○ |
| C-13 | Shutdown()でシャットダウン処理 | E-02 (64-78行目) | ○ |
| C-14 | Thread.WaitForForegroundThreads()の呼び出し | E-02 (66行目) | ○ |
| C-15 | Environment.ShutdownCore()の呼び出し | E-02 (68行目) | ○ |
| C-16 | ReachabilityInstrumentationSupport対応 | E-02 (72-75行目) | ○ |
| C-17 | MITライセンス | E-01 (1-2行目), E-02 (1-2行目) | ○ |
| C-18 | minipal/descriptorlimitの使用 | E-01 (6行目) | ○ |
| C-19 | 起動時間1/10〜1/100 | **根拠なし**（ベンチマーク参照推奨） | △ |
| C-20 | メモリ使用量50%削減 | **根拠なし**（測定データ参照推奨） | △ |
| C-21 | IL3000-IL3099エラーコード範囲 | **根拠なし**（公式ドキュメント参照推奨） | △ |
| C-22 | .NET 7で正式サポート | E-03（機能説明から推定） | ○ |
| C-23 | eager class constructorsの実行 | E-01 (33行目コメント) | ○ |
| C-24 | frozen stringsの最適化 | E-01 (33行目コメント) | ○ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス数値の具体的な測定データ
  - 候補：Microsoft Benchmarks / TechEmpower / 公式ブログ
- トリミング警告コードの完全なリスト
  - 候補：`docs/design/tools/illink` / 公式トリミングドキュメント
- ILC（IL Compiler）の詳細実装
  - 候補：`src/coreclr/tools/aot/ILCompiler` / ILCプロジェクトファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セクション定義とブートストラップ処理（ソースコードで確認可能）
- 1: 中リスク - パフォーマンス数値（外部ベンチマーク参照推奨）
- 1: 中リスク - エラーコード範囲（公式ドキュメント照合推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] main.cppのセクション定義がドキュメントの説明と一致しているか確認
- [ ] StartupCodeHelpers.Extensions.csの処理フローが正確に反映されているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] パフォーマンス数値についてMicrosoft公式ベンチマークと照合
- [ ] トリミング警告コードについて公式ドキュメントと照合
