---
generated_at: 2026-01-30 11:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 21
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：30-System.Xml.XmlSerializer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：21 / 24、根拠なし：3
- 優先レビュー（高）
  1. **sgen.exeの詳細**：事前生成ツールの詳細確認が必要
  2. **.NET 6ソースジェネレータ対応**：最新の対応状況確認が必要
  3. **スレッドセーフ性の詳細**：ドキュメント確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/XmlSerializer.cs` (112-168行目)
- E-02: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/XmlSerializer.cs` (208-272行目)
- E-03: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/XmlSerializer.cs` (332-526行目)
- E-04: `src/libraries/System.Private.Xml/src/System/Xml/Serialization/XmlSerializer.cs` (779-825行目)
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XmlSerializerクラスが存在 | E-01 (112行目) | ○ |
| C-02 | s_modeフィールド（SerializationMode）が存在 | E-01 (114行目) | ○ |
| C-03 | Modeプロパティで動的/リフレクション判定 | E-01 (116-120行目) | ○ |
| C-04 | _tempAssembly、_primitiveType、_mappingフィールドが存在 | E-01 (130-139行目) | ○ |
| C-05 | s_cacheフィールド（TempAssemblyCache）が存在 | E-01 (141行目) | ○ |
| C-06 | Trim警告メッセージ定数（TrimSerializationWarning等）が存在 | E-01 (161-163行目) | ○ |
| C-07 | protectedデフォルトコンストラクタが存在 | E-01 (166-168行目) | ○ |
| C-08 | XmlSerializer(Type)コンストラクタが存在 | E-02 (208-212行目) | ○ |
| C-09 | XmlSerializer(Type, string)コンストラクタがメイン初期化ロジック | E-02 (216-272行目) | ○ |
| C-10 | Serialize(TextWriter, object)メソッドが存在 | E-03 (332-337行目) | ○ |
| C-11 | Serialize(XmlWriter,...)メソッドがコア実装 | E-03 (369-419行目) | ○ |
| C-12 | Deserialize(Stream)メソッドが存在 | E-03 (442-448行目) | ○ |
| C-13 | Deserialize(XmlReader,...)メソッドがコア実装 | E-03 (484-526行目) | ○ |
| C-14 | CanDeserialize(XmlReader)メソッドが存在 | E-03 (543-566行目) | ○ |
| C-15 | UnknownNodeイベントが存在 | E-04 (779-789行目) | ○ |
| C-16 | UnknownAttributeイベントが存在 | E-04 (791-801行目) | ○ |
| C-17 | UnknownElementイベントが存在 | E-04 (803-813行目) | ○ |
| C-18 | UnreferencedObjectイベントが存在 | E-04 (815-825行目) | ○ |
| C-19 | SerializeUsingReflection内部メソッドが存在 | E-03 (421-428行目) | ○ |
| C-20 | DeserializeUsingReflection内部メソッドが存在 | E-03 (528-535行目) | ○ |
| C-21 | ShouldUseReflectionBasedSerializationメソッドが存在 | E-03 (537-541行目) | ○ |
| C-22 | sgen.exeで事前生成可能 | **根拠なし** | △ |
| C-23 | .NET 6ソースジェネレータ対応 | **根拠なし** | △ |
| C-24 | XmlSerializerインスタンスがスレッドセーフ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **sgen.exeの詳細**
  - 理由: ソースコードからは事前生成ツールの詳細を確認できない
  - 候補: MSBuildタスク / sgen.exe実装 / 公式ドキュメント

- **.NET 6ソースジェネレータ対応**
  - 理由: 最新の対応状況を確認していない
  - 候補: System.Xml.Serialization.SourceGenerator / 公式ドキュメント

- **スレッドセーフ性**
  - 理由: ソースコードの詳細分析が必要
  - 候補: 公式ドキュメント / コードレビュー

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - XmlSerializerクラス構造、メソッド（ソースコードから直接確認可能）
- **0: 低リスク** - イベント処理（ソースコードから確認可能）
- **1: 中リスク** - 事前生成ツール（外部ツール確認が必要）
- **1: 中リスク** - ソースジェネレータ対応（最新情報確認が必要）
- **1: 中リスク** - スレッドセーフ性（ドキュメント確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] XmlSerializerのコンストラクタオーバーロードが正確に記述されているか確認
- [ ] Serialize/Deserializeの動作説明が正確か確認
- [ ] イベント（UnknownNode等）の使用方法が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースと一致しているか確認
- [ ] sgen.exeによる事前生成の詳細を公式ドキュメントで確認
- [ ] .NET 6以降のソースジェネレータ対応状況を確認
- [ ] スレッドセーフ性を公式ドキュメントで確認
