---
generated_at: 2026-01-30 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：31-Microsoft.Extensions.DependencyInjection

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件のマイクロ秒オーダー**：定量的なベンチマーク根拠なし
  2. **サードパーティDIコンテナとの互換性**：Abstractionsの設計意図からの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceProvider.cs`
- E-02: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceProviderOptions.cs`
- E-03: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteFactory.cs`
- E-04: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceProviderEngineScope.cs`
- E-05: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceIdentifier.cs`
- E-06: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/DynamicServiceProviderEngine.cs`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServiceProviderがIServiceProvider, IKeyedServiceProvider, IDisposable, IAsyncDisposableを実装 | E-01 (20行目) | ○ |
| C-02 | 3種類のライフタイム（Singleton/Scoped/Transient）をサポート | E-01, E-04 | ○ |
| C-03 | Keyedサービスによる名前付きサービス登録・解決 | E-01 (114-128行目) | ○ |
| C-04 | ValidateScopesオプションでスコープ検証が可能 | E-01 (68-71行目), E-02 | ○ |
| C-05 | ValidateOnBuildオプションで起動時検証が可能 | E-01 (73-93行目), E-02 | ○ |
| C-06 | CallSiteFactoryがサービス解決ロジックを担当 | E-01 (60行目), E-03 | ○ |
| C-07 | ServiceProviderEngineScopeがスコープ管理を担当 | E-01 (55行目), E-04 | ○ |
| C-08 | ConcurrentDictionaryでServiceAccessorをキャッシュ | E-01 (31行目, 211行目) | ○ |
| C-09 | DynamicServiceProviderEngineでIL/Expression Tree動的生成 | E-06 | ○ |
| C-10 | NativeAOT環境ではDynamicEngineが無効化 | E-01 (41-50行目) | ○ |
| C-11 | AnyKeyは列挙型サービスでのみ使用可能 | E-01 (119-125行目) | ○ |
| C-12 | 組み込みサービスとしてIServiceProvider等を自動登録 | E-01 (63-66行目) | ○ |
| C-13 | CreateScope()で新しいスコープを作成 | E-01 (270-278行目) | ○ |
| C-14 | Dispose()でスコープ内のサービスを破棄 | E-01 (173-177行目) | ○ |
| C-15 | DisposeAsync()で非同期破棄が可能 | E-01 (180-184行目) | ○ |
| C-16 | DependencyInjectionEventSourceでイベント記録 | E-01 (95, 189, 213, 245行目) | ○ |
| C-17 | 最も多くのパラメータを持つ解決可能なコンストラクタを選択 | E-03 | ○ |
| C-18 | 循環依存を検出してエラーをスロー | E-03 (CallSiteChain) | ○ |
| C-19 | Singletonサービスはキャッシュ場所がRoot | E-01 (249-252行目) | ○ |
| C-20 | BlazorBasicTestAppで補助機能として使用 | E-08 | ○ |
| C-21 | サービス解決はマイクロ秒オーダー | **根拠なし** | △ |
| C-22 | Autofac、DryIoc等との互換性を提供 | **根拠不足** | △ |
| C-23 | .NET 8以降でKeyedサービスが追加 | E-01 (GetKeyedServiceメソッドの存在) | ○ |
| C-24 | 破棄済みプロバイダーへのアクセスでObjectDisposedException | E-01 (207-210行目, 272-275行目) | ○ |
| C-25 | DebuggerDisplayとDebuggerTypeProxyでデバッグ支援 | E-01 (18-19行目, 306-319行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（マイクロ秒オーダー）の根拠
  - 候補：ベンチマークテスト / パフォーマンスドキュメント / BenchmarkDotNet結果
- サードパーティDIコンテナとの互換性
  - 候補：DI.External.Testsディレクトリの実装 / Abstractionsパッケージの設計意図ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い
- 1: 中リスク - パフォーマンス要件の定量的根拠が必要な場合

## 6) レビュアーチェックリスト（最小）
- [ ] ServiceProviderの主要メソッド（GetService, GetKeyedService, CreateScope, Dispose）の動作確認
- [ ] ライフタイム管理（Singleton/Scoped/Transient）の説明が正確か確認
- [ ] エラーケースの網羅性確認
- [ ] パフォーマンス要件が実際の要件に合致しているか確認
