---
generated_at: 2026-01-30 10:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-Microsoft.Extensions.Hosting

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/Microsoft.Extensions.Hosting/src/HostBuilder.cs`
- E-02: `src/libraries/Microsoft.Extensions.Hosting/src/Host.cs`
- E-03: `src/libraries/Microsoft.Extensions.Hosting/src/Internal/Host.cs`
- E-04: `src/libraries/Microsoft.Extensions.Hosting/src/HostOptions.cs`
- E-05: `src/libraries/Microsoft.Extensions.Hosting/src/Internal/ConsoleLifetime.cs`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HostBuilderがIHostBuilderを実装 | E-01 (22行目) | ○ |
| C-02 | Build()は一度のみ呼び出し可能 | E-01 (154-158行目) | ○ |
| C-03 | DiagnosticListenerでビルドイベントを記録 | E-01 (162行目, 173-183行目) | ○ |
| C-04 | InitializeHostConfiguration()で設定初期化 | E-01 (208-218行目) | ○ |
| C-05 | InitializeHostingEnvironment()で環境設定 | E-01 (222-251行目) | ○ |
| C-06 | EnvironmentKey未設定時はProductionがデフォルト | E-01 (231行目) | ○ |
| C-07 | InitializeAppConfiguration()でアプリ設定構築 | E-01 (277-289行目) | ○ |
| C-08 | InitializeServiceProvider()でDI構築 | E-01 (334-364行目) | ○ |
| C-09 | Development環境でValidateOnBuild/ValidateScopesが有効 | E-01 (351-354行目) | ○ |
| C-10 | PopulateServiceCollection()で基本サービス登録 | E-01 (292-331行目) | ○ |
| C-11 | IHostEnvironment、IHostApplicationLifetime等をSingletonで登録 | E-01 (301-310行目) | ○ |
| C-12 | AddLogging()、AddOptions()を呼び出し | E-01 (329-330行目) | ○ |
| C-13 | ConfigureHostConfiguration()で設定デリゲート追加 | E-01 (63-69行目) | ○ |
| C-14 | ConfigureAppConfiguration()で設定デリゲート追加 | E-01 (79-85行目) | ○ |
| C-15 | ConfigureServices()でサービス登録デリゲート追加 | E-01 (93-99行目) | ○ |
| C-16 | UseServiceProviderFactory()でDIファクトリ変更 | E-01 (107-129行目) | ○ |
| C-17 | ConfigureContainer()でコンテナ設定デリゲート追加 | E-01 (139-145行目) | ○ |
| C-18 | Propertiesでビルド中のデータ共有 | E-01 (54行目) | ○ |
| C-19 | DefaultServiceProviderFactoryがデフォルト | E-01 (47行目) | ○ |
| C-20 | ResolveHost()でIHostを解決 | E-01 (366-385行目) | ○ |
| C-21 | WasmBrowser（ASP.NET Core統合）で補助機能 | E-07 | ○ |
| C-22 | BlazorHosted（ASP.NET Core統合）で補助機能 | E-07 | ○ |
| C-23 | Runtime Config Test（StartupHook）で補助機能 | E-07 | ○ |
| C-24 | ContentRootPathの解決ロジック | E-01 (253-264行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] HostBuilderのBuildフローの説明が正確か確認
- [ ] Development環境での自動検証設定の説明が正確か確認
- [ ] PopulateServiceCollection()で登録されるサービスの網羅性確認
- [ ] 画面機能マッピングの対応が正確か確認
