---
generated_at: 2026-01-30 10:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-Microsoft.Extensions.Caching.Memory

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/Microsoft.Extensions.Caching.Memory/src/MemoryCache.cs`
- E-02: `src/libraries/Microsoft.Extensions.Caching.Memory/src/CacheEntry.cs`
- E-03: `src/libraries/Microsoft.Extensions.Caching.Memory/src/MemoryCacheOptions.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MemoryCacheがIMemoryCacheを実装 | E-01 (24行目) | ○ |
| C-02 | CoherentStateでConcurrentDictionaryを管理 | E-01 (714-825行目) | ○ |
| C-03 | 文字列キーとオブジェクトキーで別々のDictionary | E-01 (717-721行目) | ○ |
| C-04 | CreateEntry()でCacheEntryを作成 | E-01 (99-105行目) | ○ |
| C-05 | SetEntry()でエントリを保存 | E-01 (107-202行目) | ○ |
| C-06 | TryGetValue()でキャッシュから取得 | E-01 (205-213行目) | ○ |
| C-07 | ReadOnlySpan<char>のオーバーロード（.NET 9） | E-01 (224-261行目) | ○ |
| C-08 | PostProcessTryGetValue()で期限切れチェック | E-01 (264-316行目) | ○ |
| C-09 | LastAccessed更新でスライディング有効期限対応 | E-01 (274行目) | ○ |
| C-10 | TrackLinkedCacheEntriesで依存関係追跡 | E-01 (277-282行目) | ○ |
| C-11 | 統計収集（Hits/Misses） | E-01 (286-313行目) | ○ |
| C-12 | Remove()でエントリ削除 | E-01 (319-339行目) | ○ |
| C-13 | Clear()で全エントリ削除 | E-01 (344-354行目) | ○ |
| C-14 | GetCurrentStatistics()で統計取得 | E-01 (360-375行目) | ○ |
| C-15 | StartScanForExpiredItemsIfNeeded()でバックグラウンドスキャン | E-01 (387-400行目) | ○ |
| C-16 | ScanForExpiredItems()で期限切れエントリ削除 | E-01 (464-477行目) | ○ |
| C-17 | TriggerOvercapacityCompaction()でコンパクション開始 | E-01 (524-544行目) | ○ |
| C-18 | Compact()でLRU順、優先度順にエントリ削除 | E-01 (575-661行目) | ○ |
| C-19 | ExpirePriorityBucket()で優先度別削除 | E-01 (635-660行目) | ○ |
| C-20 | SizeLimit設定時にSizeなしでSetするとエラー | E-01 (115-118行目) | ○ |
| C-21 | Dispose()でリソース解放 | E-01 (664-685行目) | ○ |
| C-22 | TrackStatisticsでStats有効化 | E-01 (60-64行目) | ○ |
| C-23 | NeverRemove優先度のエントリは削除されない | E-01 (613行目) | ○ |
| C-24 | 画面機能マッピングに該当なし | E-04で確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] CreateEntry/SetEntry/TryGetValueの動作が正確か確認
- [ ] コンパクションロジック（優先度順、LRU順）の説明が正確か確認
- [ ] ReadOnlySpan<char>オーバーロードの.NET 9対応の説明が正確か確認
- [ ] CoherentStateの並行性制御の説明が正確か確認
