---
generated_at: 2026-01-30 10:25:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-Microsoft.Extensions.Http

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/Microsoft.Extensions.Http/src/DefaultHttpClientFactory.cs`
- E-02: `src/libraries/Microsoft.Extensions.Http/src/ActiveHandlerTrackingEntry.cs`
- E-03: `src/libraries/Microsoft.Extensions.Http/src/ExpiredHandlerTrackingEntry.cs`
- E-04: `src/libraries/Microsoft.Extensions.Http/src/HttpClientFactoryOptions.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DefaultHttpClientFactoryがIHttpClientFactory, IHttpMessageHandlerFactoryを実装 | E-01 (19行目) | ○ |
| C-02 | ConcurrentDictionaryでアクティブハンドラーを管理 | E-01 (51行目) | ○ |
| C-03 | ConcurrentQueueで期限切れハンドラーを管理 | E-01 (59行目) | ○ |
| C-04 | デフォルトクリーンアップ間隔は10秒 | E-01 (34行目) | ○ |
| C-05 | CreateClient()でハンドラー取得とHttpClient作成 | E-01 (103-117行目) | ○ |
| C-06 | HttpClient生成時にdisposeHandler: false | E-01 (108行目) | ○ |
| C-07 | HttpClientActionsを適用 | E-01 (110-114行目) | ○ |
| C-08 | CreateHandler()でキャッシュからハンドラー取得 | E-01 (119-128行目) | ○ |
| C-09 | CreateHandlerEntry()でハンドラー構築 | E-01 (131-190行目) | ○ |
| C-10 | SuppressHandlerScope=falseでスコープ作成 | E-01 (137-141行目) | ○ |
| C-11 | フィルターを逆順に適用 | E-01 (151-154行目) | ○ |
| C-12 | LifetimeTrackingHttpMessageHandlerでラップ | E-01 (159行目) | ○ |
| C-13 | ActiveHandlerTrackingEntryで有効期限管理 | E-01 (168行目), E-02 | ○ |
| C-14 | ExpiryTimer_Tick()で期限切れ処理 | E-01 (193-215行目) | ○ |
| C-15 | ExpiredHandlerTrackingEntryをキューに追加 | E-01 (209-210行目) | ○ |
| C-16 | StartHandlerEntryTimer()でタイマー開始 | E-01 (218-221行目) | ○ |
| C-17 | StartCleanupTimer()でクリーンアップタイマー開始 | E-01 (224-230行目) | ○ |
| C-18 | StopCleanupTimer()でタイマー停止 | E-01 (233-240行目) | ○ |
| C-19 | CleanupTimer_Tick()でクリーンアップ実行 | E-01 (243-314行目) | ○ |
| C-20 | CanDisposeでGC可能性判定 | E-01 (281行目), E-03 | ○ |
| C-21 | CanDispose=falseの場合キューに戻す | E-01 (296-298行目) | ○ |
| C-22 | Logクラスでイベントロギング | E-01 (316-390行目) | ○ |
| C-23 | Lazy<ILogger>で循環依存回避 | E-01 (94-100行目) | ○ |
| C-24 | 画面機能マッピングに該当なし | E-05で確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] CreateClient/CreateHandlerの動作が正確か確認
- [ ] ハンドラーライフサイクル管理（Active→Expired→Dispose）の説明が正確か確認
- [ ] フィルターチェーンの逆順適用の説明が正確か確認
- [ ] クリーンアップロジックの説明が正確か確認
