---
generated_at: 2026-01-30 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-Microsoft.Extensions.FileProviders.Physical

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/Microsoft.Extensions.FileProviders.Physical/src/PhysicalFileProvider.cs`
- E-02: `src/libraries/Microsoft.Extensions.FileProviders.Physical/src/PhysicalFilesWatcher.cs`
- E-03: `src/libraries/Microsoft.Extensions.FileProviders.Physical/src/ExclusionFilters.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PhysicalFileProviderがIFileProvider, IDisposableを実装 | E-01 (23行目) | ○ |
| C-02 | コンストラクタで絶対パスチェック | E-01 (56-59行目) | ○ |
| C-03 | コンストラクタでディレクトリ存在チェック | E-01 (64-67行目) | ○ |
| C-04 | Root プロパティでルートパスを公開 | E-01 (226行目) | ○ |
| C-05 | ExclusionFiltersで除外フィルター設定 | E-01 (29行目, 54行目) | ○ |
| C-06 | DOTNET_USE_POLLING_FILE_WATCHER環境変数 | E-01 (25行目, 188-196行目) | ○ |
| C-07 | UsePollingFileWatcherプロパティ | E-01 (87-109行目) | ○ |
| C-08 | UseActivePollingプロパティ | E-01 (126-139行目) | ○ |
| C-09 | FileWatcher遅延初期化 | E-01 (141-158行目) | ○ |
| C-10 | CreateFileWatcher()でFileSystemWatcherまたはnull作成 | E-01 (160-184行目) | ○ |
| C-11 | Browser/iOS/tvOSでポーリングにフォールバック | E-01 (167-172行目) | ○ |
| C-12 | Dispose()でリソース解放 | E-01 (201-221行目) | ○ |
| C-13 | GetFullPath()でパストラバーサル防止 | E-01 (228-251行目) | ○ |
| C-14 | PathUtils.PathNavigatesAboveRoot()でチェック | E-01 (230-233行目) | ○ |
| C-15 | IsUnderneathRoot()でルート内チェック | E-01 (253-256行目) | ○ |
| C-16 | GetFileInfo()でIFileInfoを返却 | E-01 (263-292行目) | ○ |
| C-17 | 相対パスの先頭スラッシュをトリム | E-01 (271行目) | ○ |
| C-18 | 絶対パスの場合はNotFoundFileInfo | E-01 (274-277行目) | ○ |
| C-19 | GetDirectoryContents()でIDirectoryContentsを返却 | E-01 (306-339行目) | ○ |
| C-20 | Watch()でIChangeTokenを返却 | E-01 (355-366行目) | ○ |
| C-21 | Watch()でnullやinvalidならNullChangeToken | E-01 (357-360行目) | ○ |
| C-22 | FileWatcher.CreateFileChangeToken()を呼び出し | E-01 (365行目) | ○ |
| C-23 | DebuggerDisplayでデバッグ支援 | E-01（存在確認） | ○ |
| C-24 | 画面機能マッピングに該当なし | E-04で確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] コンストラクタのパス検証ロジックが正確か確認
- [ ] GetFileInfo/GetDirectoryContentsのパストラバーサル防止が正確か確認
- [ ] Watch()のポーリング/FileSystemWatcher切り替えが正確か確認
- [ ] 環境変数DOTNET_USE_POLLING_FILE_WATCHERの動作が正確か確認
