---
generated_at: 2026-01-30 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-Microsoft.Extensions.FileSystemGlobbing

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Matcher.cs`
- E-02: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/PatternMatchingResult.cs`
- E-03: `src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/MatcherContext.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Matcherがパターンマッチングのメインクラス | E-01 (97行目) | ○ |
| C-02 | デフォルトでStringComparison.OrdinalIgnoreCase | E-01 (110-111行目) | ○ |
| C-03 | ComparisonTypeプロパティで比較方法を保持 | E-01 (105行目) | ○ |
| C-04 | _includePatterns, _excludePatterns, _includeOrExcludePatterns | E-01 (99-101行目) | ○ |
| C-05 | _preserveFilterOrderでフィルター順序モード | E-01 (103行目) | ○ |
| C-06 | PatternBuilderでパターンをビルド | E-01 (102行目) | ○ |
| C-07 | preserveFilterOrder=trueで順序保持 | E-01 (132-147行目) | ○ |
| C-08 | preserveFilterOrder=falseでInclude優先 | E-01 (138-147行目) | ○ |
| C-09 | AddInclude()でインクルードパターン追加 | E-01 (161-169行目) | ○ |
| C-10 | AddExclude()でエクスクルードパターン追加 | E-01 (183-191行目) | ○ |
| C-11 | AddInclude/AddExcludeはMatcher自身を返却（Fluent API） | E-01 (168, 190行目) | ○ |
| C-12 | Execute()でDirectoryInfoBaseを受け取る | E-01 (198行目) | ○ |
| C-13 | ArgumentNullException.ThrowIfNull(directoryInfo) | E-01 (200行目) | ○ |
| C-14 | preserveFilterOrderに応じてMatcherContext作成 | E-01 (202-204行目) | ○ |
| C-15 | MatcherContext.Execute()を呼び出し | E-01 (203, 204行目) | ○ |
| C-16 | パターン構文（*, **, ?等）のドキュメント | E-01 (16-95行目のXMLコメント) | ○ |
| C-17 | 相対パス（..）のサポート | E-01 (89-93行目のXMLコメント) | ○ |
| C-18 | IncludeOrExcludeValue<IPattern>構造体 | E-01 (_includeOrExcludePatternsの型から推測) | ○ |
| C-19 | PatternMatchingResultを返却 | E-01 (203, 204行目), E-02 | ○ |
| C-20 | PatternMatchingResult.HasMatches | E-02 | ○ |
| C-21 | PatternMatchingResult.Files | E-02 | ○ |
| C-22 | 画面機能マッピングに該当なし | E-04で確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] パターン構文（*, **, ?等）の説明が正確か確認
- [ ] preserveFilterOrder=true/falseの動作が正確か確認
- [ ] AddInclude/AddExcludeのFluent API対応が正確か確認
- [ ] Execute()の動作が正確か確認
