---
generated_at: 2026-01-30 10:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-WasmAppBuilder

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tasks/WasmAppBuilder/WasmAppBuilderBaseTask.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WasmAppBuilderBaseTaskがTaskを継承 | E-01 (16行目) | ○ |
| C-02 | AppDirプロパティ（Required） | E-01 (18-20行目) | ○ |
| C-03 | Assembliesプロパティ（Required） | E-01 (22-23行目) | ○ |
| C-04 | MainAssemblyNameプロパティ（Required） | E-01 (48-49行目) | ○ |
| C-05 | NativeAssetsプロパティ（Required） | E-01 (28-30行目) | ○ |
| C-06 | HostConfigsプロパティ（Required） | E-01 (51-52行目) | ○ |
| C-07 | RuntimeConfigJsonPathプロパティ | E-01 (25行目) | ○ |
| C-08 | SatelliteAssembliesプロパティ | E-01 (41行目) | ○ |
| C-09 | IcuDataFileNamesプロパティ | E-01 (39行目) | ○ |
| C-10 | InvariantGlobalizationプロパティ | E-01 (42行目) | ○ |
| C-11 | FilesToIncludeInFileSystemプロパティ | E-01 (43行目) | ○ |
| C-12 | ExtraFilesToDeployプロパティ | E-01 (44行目) | ○ |
| C-13 | DefaultHostConfigプロパティ | E-01 (46行目) | ○ |
| C-14 | RuntimeArgsForHostプロパティ | E-01 (54行目) | ○ |
| C-15 | _fileWritesで書き込みファイルを記録 | E-01 (32行目) | ○ |
| C-16 | FileWritesが出力プロパティ | E-01 (34-35行目) | ○ |
| C-17 | Execute()でtry-catchしてExecuteInternal()を呼び出し | E-01 (56-67行目) | ○ |
| C-18 | LogAsErrorExceptionをキャッチしてLog.LogError | E-01 (63-66行目) | ○ |
| C-19 | ExecuteInternal()は抽象メソッド | E-01 (69行目) | ○ |
| C-20 | ProcessSatelliteAssemblies()でカルチャ処理 | E-01 (73-88行目) | ○ |
| C-21 | WASM0002警告でCultureName欠落を通知 | E-01 (81行目) | ○ |
| C-22 | UpdateRuntimeConfigJson()でJSON更新 | E-01 (90-163行目) | ○ |
| C-23 | FileCopyChecked()でファイルコピー | E-01 (169-189行目) | ○ |
| C-24 | WasmBasic、WasmBrowserTest、WasmBrowserで使用 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] MSBuildタスクの入力プロパティが正確に説明されているか確認
- [ ] Execute/ExecuteInternalの処理フローが正確か確認
- [ ] UpdateRuntimeConfigJson()のJSON処理が正確か確認
- [ ] 画面機能マッピングとの対応が正確か確認
