---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：41-MonoAOTCompiler

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：定量的な指標が未定義
  2. **セキュリティ考慮事項**：一般的な記述のみ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/tasks/AotCompilerTask/MonoAOTCompiler.cs` - メインソースコード
- E-02: `src/tasks/AotCompilerTask/MonoAOTCompiler.csproj` - プロジェクト定義
- E-03: `src/mono/msbuild/common/MonoAOTCompiler.props` - MSBuildプロパティ
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MonoAOTCompilerはMSBuildタスクとして実装される | E-01 (21行目: `public class MonoAOTCompiler : Microsoft.Build.Utilities.Task`) | ○ |
| C-02 | CompilerBinaryPathは必須パラメータ | E-01 (26-27行目: `[Required] public string CompilerBinaryPath`) | ○ |
| C-03 | Assembliesは必須パラメータ | E-01 (36-37行目: `[Required] public ITaskItem[] Assemblies`) | ○ |
| C-04 | OutputDirは必須パラメータ | E-01 (50-53行目: `[NotNull][Required] public string? OutputDir`) | ○ |
| C-05 | UseLLVMでLLVM使用を制御 | E-01 (85行目: `public bool UseLLVM { get; set; }`) | ○ |
| C-06 | LLVMOnlyモードではUseLLVM必須 | E-01 (420-423行目: 条件チェック) | ○ |
| C-07 | 並列度はProcessorCount基準で決定 | E-01 (543行目: `Math.Min(_assembliesToCompile.Count, Environment.ProcessorCount)`) | ○ |
| C-08 | DisableParallelAotで並列無効化 | E-01 (543行目: `DisableParallelAot ? 1 : ...`) | ○ |
| C-09 | AOTモードはNormal等7種類 | E-01 (1340-1349行目: enum MonoAotMode) | ○ |
| C-10 | 出力形式はObjectFile等3種類 | E-01 (1351-1356行目: enum MonoAotOutputType) | ○ |
| C-11 | ライブラリ形式はDll等3種類 | E-01 (1358-1363行目: enum MonoAotLibraryFormat) | ○ |
| C-12 | AOTモジュールテーブル言語はC/ObjC | E-01 (1365-1369行目: enum MonoAotModulesTableLanguage) | ○ |
| C-13 | ProcessAndValidateArgumentsで検証 | E-01 (329-485行目) | ○ |
| C-14 | FilterOutUnmanagedAssembliesで非マネージド除外 | E-01 (625-653行目) | ○ |
| C-15 | PrecompileLibraryでコンパイル実行 | E-01 (1040-1102行目) | ○ |
| C-16 | Utils.TryRunProcessで外部プロセス実行 | E-01 (1049-1056行目) | ○ |
| C-17 | レスポンスファイル経由で引数渡し | E-01 (1026-1031行目: StreamWriter使用) | ○ |
| C-18 | MONO_PATH環境変数を設定 | E-01 (1020-1024行目) | ○ |
| C-19 | キャッシュ機能でインクリメンタルビルド | E-01 (270行目: CacheFilePath, 526行目: FileCache) | ○ |
| C-20 | Parallel.ForEachで並列実行 | E-01 (584-602行目) | ○ |
| C-21 | UseStaticLinkingとLibraryは併用不可 | E-01 (461-464行目) | ○ |
| C-22 | UseDirectPInvokeとDirectPInvokesは併用不可 | E-01 (444-447行目) | ○ |
| C-23 | GenerateAotModulesTableでテーブル生成 | E-01 (1126-1212行目) | ○ |
| C-24 | CompiledAssembliesが出力 | E-01 (73-74行目: [Output]) | ○ |
| C-25 | FileWritesが出力 | E-01 (305-306行目: [Output]) | ○ |
| C-26 | IntermediateOutputPathは必須 | E-01 (302-303行目: [Required]) | ○ |
| C-27 | パフォーマンス要件の具体的数値 | **根拠なし** | △ |
| C-28 | セキュリティ考慮事項の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の定量的な値（処理時間、スループット）はソースコードからは特定できない
  - 候補：ベンチマークテスト結果 / パフォーマンス設計書 / 運用実績データ
- セキュリティ要件の詳細仕様は明文化されていない
  - 候補：セキュリティ設計書 / コードレビュー基準

## 5) リスクフラグ（レビュー観点）
- 0: 主張C-01〜C-26は低リスク（ソースコードで直接確認可能）
- 1: 主張C-27, C-28は中リスク（運用・設計上の補足情報が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] CompilerBinaryPath, Assemblies, OutputDirの必須パラメータ仕様は正確か
- [ ] AOTモード（7種類）の説明は適切か
- [ ] 並列処理の動作説明は正確か
- [ ] パフォーマンス要件について追加情報が必要か判断
- [ ] セキュリティ考慮事項について追加情報が必要か判断
