---
generated_at: 2026-01-30 12:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：42-Crossgen2Tasks

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **MSBuildタスク詳細実装**：プロジェクトファイルのみで詳細コード未確認
  2. **複合イメージビルドの詳細**：概念的記述のみ

## 2) 参照した情報（Evidence一覧）

- E-01: `src/coreclr/tools/aot/crossgen2/Crossgen2RootCommand.cs` - コマンドライン定義
- E-02: `src/tasks/Crossgen2Tasks/Crossgen2Tasks.csproj` - プロジェクト定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReadyToRun形式の事前コンパイル済みイメージを生成 | E-03 (42行目), E-01 (全体構造) | ○ |
| C-02 | InputFilePathsは必須引数 | E-01 (19-20行目: Argument) | ○ |
| C-03 | ReferenceFilePathsオプションが存在 | E-01 (23-24行目: Option) | ○ |
| C-04 | TargetArchitectureオプションが存在 | E-01 (87-88行目) | ○ |
| C-05 | TargetOSオプションが存在 | E-01 (95-96行目) | ○ |
| C-06 | Optimizeオプションで最適化制御 | E-01 (37-38行目) | ○ |
| C-07 | OptimizeSpaceでサイズ優先 | E-01 (41-42行目) | ○ |
| C-08 | OptimizeTimeで速度優先 | E-01 (43-44行目) | ○ |
| C-09 | MibcFilePathsでPGOプロファイル指定 | E-01 (29-30行目) | ○ |
| C-10 | Compositeで複合イメージモード | E-01 (53-54行目) | ○ |
| C-11 | Parallelismで並列度制御 | E-01 (109-110行目) | ○ |
| C-12 | 32ビット環境で並列度制限 | E-01 (372-373行目) | ○ |
| C-13 | デフォルト並列度は24またはCPU数の小さい方 | E-01 (369行目) | ○ |
| C-14 | armelはarmに変換される | E-01 (353-356行目) | ○ |
| C-15 | Pdbオプションが存在 | E-01 (117-118行目) | ○ |
| C-16 | PerfMapオプションが存在 | E-01 (121-122行目) | ○ |
| C-17 | CustomPESectionAlignment検証 | E-01 (248-253行目) | ○ |
| C-18 | 4096以上かつ2の累乗が必要 | E-01 (251行目) | ○ |
| C-19 | SetActionでProgram.Runを呼び出し | E-01 (268行目) | ○ |
| C-20 | MakeReproPackageでリプロパッケージ作成 | E-01 (264-265行目) | ○ |
| C-21 | JitPathオプションが存在 | E-01 (97-98行目) | ○ |
| C-22 | System.CommandLineライブラリ使用 | E-01 (6-8行目: using) | ○ |
| C-23 | MSBuildタスク実装の詳細 | **根拠なし** - プロジェクトファイルのみ | △ |
| C-24 | 複合イメージビルドの詳細処理 | **根拠なし** - 概念的記述のみ | △ |

## 4) 不足情報（Unknown / Missing）
- MSBuildタスクの詳細実装コードが確認できていない（SDK側に存在する可能性）
  - 候補：dotnet/sdk リポジトリ / 外部参照DLL
- 複合イメージ（Composite）ビルドの詳細アルゴリズム
  - 候補：ILCompiler内部実装 / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 主張C-01〜C-22は低リスク（ソースコードで直接確認可能）
- 1: 主張C-23, C-24は中リスク（追加調査が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドラインオプションの説明は正確か
- [ ] 並列度の計算ロジックは正確か
- [ ] ターゲットアーキテクチャ変換の説明は適切か
- [ ] MSBuildタスクの詳細について追加調査が必要か判断
- [ ] 複合イメージビルドについて追加調査が必要か判断
