---
generated_at: 2026-01-30 12:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：43-AndroidAppBuilder

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **ApkBuilder内部処理**：ApkBuilder.csの詳細実装未確認
  2. **Android SDK/NDK連携詳細**：外部ツール連携の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tasks/AndroidAppBuilder/AndroidAppBuilder.cs` - メインソースコード
- E-02: `src/tasks/AndroidAppBuilder/AndroidAppBuilder.csproj` - プロジェクト定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AndroidAppBuilderTaskはMSBuildタスク | E-01 (10行目: `public class AndroidAppBuilderTask : Task`) | ○ |
| C-02 | RuntimeHeadersは必須 | E-01 (12-13行目: `[Required] public string[] RuntimeHeaders`) | ○ |
| C-03 | AppDirは必須 | E-01 (18-19行目: `[Required] public string AppDir`) | ○ |
| C-04 | RuntimeIdentifierは必須 | E-01 (77行目: `[Required]`) | ○ |
| C-05 | OutputDirは必須 | E-01 (80行目: `[Required]`) | ○ |
| C-06 | ProjectNameは必須 | E-01 (83行目: `[Required]`) | ○ |
| C-07 | MainLibraryFileNameはオプション | E-01 (24行目: 属性なし) | ○ |
| C-08 | Assembliesでアセンブリリスト | E-01 (28-29行目) | ○ |
| C-09 | EnvironmentVariablesで環境変数設定 | E-01 (34行目) | ○ |
| C-10 | ForceAOTでエミュレータAOT強制 | E-01 (43-44行目) | ○ |
| C-11 | ForceFullAOTで全アセンブリAOT | E-01 (48-49行目) | ○ |
| C-12 | IsLibraryModeでライブラリモード | E-01 (53-54行目) | ○ |
| C-13 | StaticLinkedRuntimeで静的リンク | E-01 (63-64行目) | ○ |
| C-14 | RuntimeComponentsで有効コンポーネント | E-01 (68-69行目) | ○ |
| C-15 | DiagnosticPortsで診断ポート設定 | E-01 (73-74行目) | ○ |
| C-16 | ApkBundlePathが出力 | E-01 (111-112行目: `[Output]`) | ○ |
| C-17 | ApkPackageIdが出力 | E-01 (114-115行目: `[Output]`) | ○ |
| C-18 | RuntimeFlavorでランタイム選択 | E-01 (99行目: `nameof(RuntimeFlavorEnum.Mono)`) | ○ |
| C-19 | BuildApkでAPK生成 | E-01 (144行目: `apkBuilder.BuildApk(...)`) | ○ |
| C-20 | ForceInterpreterでインタープリタ強制 | E-01 (109行目) | ○ |
| C-21 | ApkBuilder内部処理の詳細 | **根拠なし** - ApkBuilder.cs未読み込み | △ |
| C-22 | Android SDK/NDK連携の詳細 | **根拠なし** - 外部ツール連携未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- ApkBuilder.csの詳細実装（APK生成ロジック）
  - 候補：src/tasks/AndroidAppBuilder/ApkBuilder.cs
- Android SDK/NDKとの連携詳細
  - 候補：Android開発ドキュメント / ネイティブビルドスクリプト

## 5) リスクフラグ（レビュー観点）
- 0: 主張C-01〜C-20は低リスク（ソースコードで直接確認可能）
- 1: 主張C-21, C-22は中リスク（追加調査が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 必須パラメータの仕様は正確か
- [ ] 出力プロパティ（ApkBundlePath, ApkPackageId）の説明は適切か
- [ ] ランタイムフレーバー（Mono/CoreCLR）の選択動作は正確か
- [ ] ApkBuilder内部処理の追加調査が必要か判断
- [ ] Android SDK/NDK連携の追加調査が必要か判断
