---
generated_at: 2026-01-30 12:15:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：44-AppleAppBuilder

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **Xcode生成ロジック詳細**：Xcode.csの詳細実装未確認
  2. **コード署名プロセス詳細**：外部ツール連携の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tasks/AppleAppBuilder/AppleAppBuilder.cs` - メインソースコード
- E-02: `src/tasks/AppleAppBuilder/AppleAppBuilder.csproj` - プロジェクト定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AppleAppBuilderTaskはMSBuildタスク | E-01 (13行目: `public class AppleAppBuilderTask : Task`) | ○ |
| C-02 | TargetOSは必須で小文字変換される | E-01 (21-33行目) | ○ |
| C-03 | ProjectNameは必須 | E-01 (38-39行目: `[Required]`) | ○ |
| C-04 | AppDirは必須 | E-01 (44-45行目: `[Required]`) | ○ |
| C-05 | Assembliesは必須 | E-01 (63-64行目: `[Required]`) | ○ |
| C-06 | Archは必須 | E-01 (79-80行目: `[Required]`) | ○ |
| C-07 | AppBundlePathが出力 | E-01 (85-86行目: `[Output]`) | ○ |
| C-08 | XcodeProjectPathが出力 | E-01 (91-92行目: `[Output]`) | ○ |
| C-09 | RuntimeはMonoVM/NativeAOT/CoreCLRから選択 | E-01 (188行目: デフォルト"MonoVM") | ○ |
| C-10 | ValidateRuntimeSelectionでランタイム検証 | E-01 (200-235行目) | ○ |
| C-11 | NativeAOT時はMonoRuntimeHeaders不可 | E-01 (209-210行目) | ○ |
| C-12 | MonoVM時はMonoRuntimeHeaders必須 | E-01 (232-233行目) | ○ |
| C-13 | ForceAOTオプションが存在 | E-01 (143-144行目) | ○ |
| C-14 | ForceInterpreterオプションが存在 | E-01 (168-169行目) | ○ |
| C-15 | EnableAppSandboxオプションが存在 | E-01 (178-179行目) | ○ |
| C-16 | App Sandbox時はDevTeamProvisioning必須 | E-01 (313-316行目) | ○ |
| C-17 | DiagnosticPorts使用時はdiagnostics_tracing必須 | E-01 (308-311行目) | ○ |
| C-18 | ProjectNameにスペース不可 | E-01 (252-255行目) | ○ |
| C-19 | GenerateXcodeProjectでXcodeプロジェクト生成 | E-01 (117行目, 350行目) | ○ |
| C-20 | GenerateCMakeProjectでCMakeプロジェクト生成 | E-01 (122行目, 376行目) | ○ |
| C-21 | BuildAppBundleでアプリバンドルビルド | E-01 (112行目, 355行目) | ○ |
| C-22 | StripSymbolTableでシンボル削除 | E-01 (183行目, 367行目) | ○ |
| C-23 | AOTファイル収集処理 | E-01 (279-300行目) | ○ |
| C-24 | CoreCLR時はrpath設定 | E-01 (335-346行目) | ○ |
| C-25 | Xcode生成ロジックの詳細 | **根拠なし** - Xcode.cs未読み込み | △ |
| C-26 | コード署名プロセスの詳細 | **根拠なし** - 外部ツール連携未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- Xcode.csの詳細実装（Xcodeプロジェクト生成ロジック）
  - 候補：src/tasks/AppleAppBuilder/Xcode.cs
- コード署名とプロビジョニングの詳細
  - 候補：Apple開発ドキュメント / xcodebuild連携コード

## 5) リスクフラグ（レビュー観点）
- 0: 主張C-01〜C-24は低リスク（ソースコードで直接確認可能）
- 1: 主張C-25, C-26は中リスク（追加調査が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 必須パラメータの仕様は正確か
- [ ] ランタイム種別（MonoVM/NativeAOT/CoreCLR）の制約は正確か
- [ ] App Sandboxとプロビジョニングの関係は正確か
- [ ] DiagnosticPortsとコンポーネントの依存関係は正確か
- [ ] Xcode生成ロジックの追加調査が必要か判断
