---
generated_at: 2026-01-30 12:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：45-WebcilConverter

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **WASMラッパー詳細**：WebcilWasmWrapper.csの詳細実装

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tasks/Microsoft.NET.WebAssembly.Webcil/WebcilConverter.cs` - メインソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PE COFF形式をWebcil形式に変換 | E-01 (15-16行目: ドキュメントコメント), E-02 | ○ |
| C-02 | PEFileInfoレコードが入力情報を保持 | E-01 (20-29行目) | ○ |
| C-03 | WCFileInfoレコードが出力情報を保持 | E-01 (32-39行目) | ○ |
| C-04 | FromPortableExecutableでインスタンス作成 | E-01 (54-55行目) | ○ |
| C-05 | ConvertToWebcilで変換実行 | E-01 (57-84行目) | ○ |
| C-06 | WrapInWebAssemblyでWASMラッパー制御 | E-01 (46行目, 68-83行目) | ○ |
| C-07 | WriteConversionToで直接出力 | E-01 (86-96行目) | ○ |
| C-08 | GatherInfoでPE情報収集 | E-01 (110-176行目) | ○ |
| C-09 | マジックナンバー"WbIL" | E-01 (117-120行目: `header.id[0]='W'...`) | ○ |
| C-10 | バージョン情報の設定 | E-01 (121-122行目: `version_major`, `version_minor`) | ○ |
| C-11 | セクションオフセットの再計算 | E-01 (130-164行目) | ○ |
| C-12 | WriteHeaderでヘッダー書き込み | E-01 (178-191行目) | ○ |
| C-13 | WriteSectionHeadersでセクション書き込み | E-01 (193-199行目) | ○ |
| C-14 | CopySectionsでデータコピー | E-01 (247-257行目) | ○ |
| C-15 | デバッグディレクトリエントリの調整 | E-01 (323-348行目) | ○ |
| C-16 | OverwriteDebugDirectoryEntriesで上書き | E-01 (350-363行目) | ○ |
| C-17 | FilePosition値型の定義 | E-01 (98-103行目) | ○ |
| C-18 | SizeOfHeaderでヘッダーサイズ取得 | E-01 (105-108行目) | ○ |
| C-19 | エンディアン変換処理 | E-01 (180-189行目: BinaryPrimitives.ReverseEndianness) | ○ |
| C-20 | WriteStructureでバイナリ書き込み | E-01 (216-245行目) | ○ |
| C-21 | GetPositionOfRelativeVirtualAddressでRVA→オフセット変換 | E-01 (278-290行目) | ○ |
| C-22 | GetSectionFromFileOffsetでオフセット→セクション取得 | E-01 (293-317行目) | ○ |
| C-23 | InvalidOperationExceptionでエラー報告 | E-01 (289行目, 303行目, 316行目) | ○ |
| C-24 | WASMラッパー詳細処理 | **根拠なし** - WebcilWasmWrapper.cs未読み込み | △ |

## 4) 不足情報（Unknown / Missing）
- WebcilWasmWrapper.csの詳細実装
  - 候補：src/tasks/Microsoft.NET.WebAssembly.Webcil/WebcilWasmWrapper.cs

## 5) リスクフラグ（レビュー観点）
- 0: 主張C-01〜C-23は低リスク（ソースコードで直接確認可能）
- 1: 主張C-24は中リスク（追加調査が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] Webcilフォーマットの構造説明は正確か
- [ ] セクションオフセット計算ロジックは正確か
- [ ] デバッグディレクトリ調整の説明は適切か
- [ ] WASMラッパーの追加調査が必要か判断
