---
generated_at: 2026-01-30 12:25:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：46-ILStrip

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **AssemblyStripper詳細**：AssemblyStripper.csの詳細実装未確認
  2. **CilStripライブラリ詳細**：外部ライブラリの動作詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tasks/MonoTargetsTasks/ILStrip/ILStrip.cs` - メインソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ILStripはMSBuildタスク | E-01 (20行目: `public class ILStrip : Microsoft.Build.Utilities.Task`) | ○ |
| C-02 | Assembliesは必須パラメータ | E-01 (22-27行目: `[Required]`) | ○ |
| C-03 | DisableParallelStrippingで並列無効化 | E-01 (32行目) | ○ |
| C-04 | TrimIndividualMethodsで個別トリミング | E-01 (37行目) | ○ |
| C-05 | IntermediateOutputPathで中間出力指定 | E-01 (42行目) | ○ |
| C-06 | UpdatedAssembliesが出力 | E-01 (52-53行目: `[Output]`) | ○ |
| C-07 | ConcurrentDictionaryでスレッドセーフ | E-01 (55行目) | ○ |
| C-08 | Assemblies空チェック | E-01 (59-62行目) | ○ |
| C-09 | strippedディレクトリ作成 | E-01 (67-71行目) | ○ |
| C-10 | IBuildEngine9.RequestCoresで並列度取得 | E-01 (77-87行目) | ○ |
| C-11 | 並列度計算ロジック | E-01 (76行目: `Math.Min(...)`) | ○ |
| C-12 | Parallel.ForEachで並列処理 | E-01 (91-105行目) | ○ |
| C-13 | StripAssemblyでアセンブリストリップ | E-01 (122-156行目) | ○ |
| C-14 | AssemblyStripper.TryStripAssembly呼び出し | E-01 (138行目) | ○ |
| C-15 | 非マネージドアセンブリはスキップ | E-01 (140-141行目) | ○ |
| C-16 | TrimMethodsで個別メソッドトリミング | E-01 (158-232行目) | ○ |
| C-17 | MethodTokenFileの検証 | E-01 (161-171行目) | ○ |
| C-18 | GUID検証処理 | E-01 (212-218行目) | ○ |
| C-19 | ComputeGuidでMVID取得 | E-01 (254-259行目) | ○ |
| C-20 | ComputeMethodBodyUsageでカウント計算 | E-01 (261-302行目) | ○ |
| C-21 | CreateTrimmedAssemblyでトリミング実行 | E-01 (304-329行目) | ○ |
| C-22 | ZeroOutMethodBodyでゼロ埋め | E-01 (354-361行目) | ○ |
| C-23 | GetTrimmedAssemblyItemでメタデータ設定 | E-01 (363-370行目) | ○ |
| C-24 | 増分ビルドサポート | E-01 (188-202行目) | ○ |
| C-25 | AssemblyStripper詳細処理 | **根拠なし** - AssemblyStripper.cs未読み込み | △ |
| C-26 | CilStripライブラリの動作 | **根拠なし** - 外部ライブラリ | △ |

## 4) 不足情報（Unknown / Missing）
- AssemblyStripper.csの詳細実装
  - 候補：src/mono/browser/build/ILStrip/AssemblyStripper.cs
- CilStripライブラリの内部動作
  - 候補：外部ライブラリドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 主張C-01〜C-24は低リスク（ソースコードで直接確認可能）
- 1: 主張C-25, C-26は中リスク（追加調査が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 並列処理の動作説明は正確か
- [ ] TrimIndividualMethodsモードの説明は適切か
- [ ] メソッドボディ使用カウントのロジックは正確か
- [ ] AssemblyStripper詳細の追加調査が必要か判断
