---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：47-PInvokeTableGenerator

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **PInvokeCollector詳細**：収集ロジックの詳細
  2. **SignatureMapper詳細**：シグネチャマッピングの詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `src/tasks/WasmAppBuilder/mono/PInvokeTableGenerator.cs` - メインソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | P/Invokeテーブルを生成する | E-02, E-01 (全体構造) | ○ |
| C-02 | pinvokesリストでP/Invoke情報保持 | E-01 (25行目) | ○ |
| C-03 | callbacksリストでコールバック情報保持 | E-01 (26行目) | ○ |
| C-04 | signaturesでシグネチャ保持 | E-01 (24行目) | ○ |
| C-05 | ScanAssemblyでアセンブリスキャン | E-01 (38-42行目) | ○ |
| C-06 | Generateでテーブル生成 | E-01 (44-63行目) | ○ |
| C-07 | EmitPInvokeTableでCコード生成 | E-01 (65-185行目) | ○ |
| C-08 | ヘッダーインクルード出力 | E-01 (89-99行目) | ○ |
| C-09 | モジュール別インポートテーブル | E-01 (151-159行目) | ○ |
| C-10 | pinvoke_tables配列の生成 | E-01 (161-168行目) | ○ |
| C-11 | 可変引数の警告処理 | E-01 (115-123行目: WASM0001) | ○ |
| C-12 | WasmLinkageのマングリング | E-01 (187-196行目: CEntryPoint) | ○ |
| C-13 | MapTypeで.NET型→C型変換 | E-01 (198-216行目) | ○ |
| C-14 | Void→void, Double→double等 | E-01 (200-216行目) | ○ |
| C-15 | PickCTypeNameForUnknownType | E-01 (218-238行目) | ○ |
| C-16 | 非ValueTypeはvoid*に変換 | E-01 (222行目) | ○ |
| C-17 | ポインタ/関数ポインタはvoid* | E-01 (224-225行目) | ○ |
| C-18 | GenPInvokeDeclで宣言生成 | E-01 (262-290行目) | ○ |
| C-19 | EmitNativeToInterpでコールバック生成 | E-01 (323-402行目) | ○ |
| C-20 | wasm_native_to_interp_ftndescs配列 | E-01 (336行目) | ○ |
| C-21 | 重複シンボル検出 | E-01 (348-356行目) | ○ |
| C-22 | IsBlittableでBlittable判定 | E-01 (424-486行目) | ○ |
| C-23 | _blittableCacheでキャッシュ | E-01 (416行目) | ○ |
| C-24 | EscapeLiteralでエスケープ | E-01 (292-321行目) | ○ |
| C-25 | PInvokeCollector詳細処理 | **根拠なし** - PInvokeCollector.cs未読み込み | △ |
| C-26 | SignatureMapper詳細処理 | **根拠なし** - SignatureMapper.cs未読み込み | △ |

## 4) 不足情報（Unknown / Missing）
- PInvokeCollector.csの詳細実装
  - 候補：src/tasks/WasmAppBuilder/mono/PInvokeCollector.cs
- SignatureMapper.csの詳細実装
  - 候補：src/tasks/WasmAppBuilder/mono/SignatureMapper.cs

## 5) リスクフラグ（レビュー観点）
- 0: 主張C-01〜C-24は低リスク（ソースコードで直接確認可能）
- 1: 主張C-25, C-26は中リスク（追加調査が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 型マッピング（MapType）の説明は正確か
- [ ] WasmLinkageのシンボルマングリングは正確か
- [ ] コールバック生成の説明は適切か
- [ ] Blittable判定ロジックは正確か
- [ ] PInvokeCollector/SignatureMapperの追加調査が必要か判断
