---
generated_at: 2026-01-30 12:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：48-corehost

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **hostfxr詳細**：hostfxr内部処理の詳細
  2. **バンドル処理詳細**：シングルファイルバンドルの詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `src/native/corehost/corehost.cpp` - メインソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dotnet実行可能ファイルとして機能 | E-02, E-01 (102-103行目: CURHOST_TYPE) | ○ |
| C-02 | FEATURE_APPHOSTマクロで分岐 | E-01 (14-23行目) | ○ |
| C-03 | EMBED_HASH定義 | E-01 (39-41行目) | ○ |
| C-04 | is_exe_enabled_for_executionで検証 | E-01 (56-99行目) | ○ |
| C-05 | 埋め込みDLL名取得 | E-01 (69行目: pal::clr_palstring) | ○ |
| C-06 | パス長1024バイト制限 | E-01 (78-82行目) | ○ |
| C-07 | プレースホルダー検出 | E-01 (89-95行目) | ○ |
| C-08 | exe_startがメイン処理 | E-01 (121-307行目) | ○ |
| C-09 | get_own_executable_pathでパス取得 | E-01 (131行目) | ○ |
| C-10 | fullpathでシンボリックリンク解決 | E-01 (131行目) | ○ |
| C-11 | リネーム検出（dotnet） | E-01 (177-185行目) | ○ |
| C-12 | 引数なし時のヘルプ表示 | E-01 (187-202行目) | ○ |
| C-13 | hostfxr_resolver_t使用 | E-01 (210行目) | ○ |
| C-14 | bundle_marker_t::is_bundle()判定 | E-01 (218行目) | ○ |
| C-15 | hostfxr_main_bundle_startupinfo呼び出し | E-01 (236行目) | ○ |
| C-16 | hostfxr_main_startupinfo呼び出し | E-01 (264行目) | ○ |
| C-17 | main_fn_v1フォールバック | E-01 (291-294行目) | ○ |
| C-18 | trace::setup()初期化 | E-01 (315行目) | ○ |
| C-19 | trace::info()でログ出力 | E-01 (317-325行目) | ○ |
| C-20 | trace::flush()で終了処理 | E-01 (335行目) | ○ |
| C-21 | apphost::buffer_errors()（Windows） | E-01 (329行目) | ○ |
| C-22 | apphost::write_buffered_errors()（Windows） | E-01 (339行目) | ○ |
| C-23 | CurrentHostFindFailureエラー | E-01 (134行目) | ○ |
| C-24 | AppHostExeNotBoundFailureエラー | E-01 (145行目) | ○ |
| C-25 | CoreHostEntryPointFailureエラー | E-01 (184行目, 280行目, 298行目) | ○ |
| C-26 | FrameworkMissingFailureエラー | E-01 (243行目, 271行目) | ○ |
| C-27 | hostfxr内部処理の詳細 | **根拠なし** - hostfxr.cpp未読み込み | △ |
| C-28 | バンドル処理の詳細 | **根拠なし** - bundle関連ファイル未読み込み | △ |

## 4) 不足情報（Unknown / Missing）
- hostfxrの内部処理（ランタイム解決ロジック）
  - 候補：src/native/corehost/fxr/hostfxr.cpp
- シングルファイルバンドルの詳細処理
  - 候補：src/native/corehost/bundle/

## 5) リスクフラグ（レビュー観点）
- 0: 主張C-01〜C-26は低リスク（ソースコードで直接確認可能）
- 1: 主張C-27, C-28は中リスク（追加調査が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] FEATUREマクロの説明は正確か
- [ ] 埋め込みDLL名の検証ロジックは正確か
- [ ] エラーコードの説明は適切か
- [ ] hostfxr連携の追加調査が必要か判断
- [ ] バンドル処理の追加調査が必要か判断
