---
generated_at: 2026-01-30 12:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 19
  claims_without_evidence: 3
confidence_derived: 0.86
---

# 根拠レポート：5-ガベージコレクター.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：19 / 22、根拠なし：3
- 優先レビュー（高）
  1. **STW時間の具体的数値**：パフォーマンス測定根拠確認推奨
  2. **BGCスループット95%**：ベンチマーク根拠確認推奨
  3. **Regions対応詳細**：.NET 7リリースノート参照推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/coreclr/gc/gc.h` - GCヘッダファイル
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング
- E-04: `src/coreclr/gc/gcinterface.h` - GCインターフェース（参照パス確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GCは自動メモリ管理機能を提供 | E-02 | ○ |
| C-02 | 世代別GC、バックグラウンドGCをサポート | E-02, E-01 | ○ |
| C-03 | LARGE_OBJECT_SIZE = 85000（85KB） | E-01 (107行目) | ○ |
| C-04 | gc_generation_numでsoh_gen0〜soh_gen2定義 | E-01 (109-115行目) | ○ |
| C-05 | loh_generation = 3 | E-01 (118行目) | ○ |
| C-06 | poh_generation = 4 | E-01 (121行目) | ○ |
| C-07 | total_generation_count = 5 | E-01 (129行目) | ○ |
| C-08 | gc_reasonでGCトリガー理由定義 | E-01 (60-80行目) | ○ |
| C-09 | bgc_stateでBGC状態定義 | E-01 (188-199行目) | ○ |
| C-10 | WKS/SVR名前空間でのGCHeap実装 | E-01 (166-177行目) | ○ |
| C-11 | g_gc_card_tableグローバル変数 | E-01 (154行目) | ○ |
| C-12 | g_gc_lowest_address/g_gc_highest_address | E-01 (155-156行目) | ○ |
| C-13 | g_gc_heap_typeグローバル変数 | E-01 (157行目) | ○ |
| C-14 | MITライセンス | E-01 (1-2行目) | ○ |
| C-15 | 画面No.3との関連（Threading Sample） | E-03 | ○ |
| C-16 | 画面No.7との関連（Log Profiler） | E-03 | ○ |
| C-17 | CreateGCHandleManager()関数 | E-01 (164行目) | ○ |
| C-18 | FEATURE_SVR_GC条件コンパイル | E-01 (172行目) | ○ |
| C-19 | MAX_GLOBAL_GC_MECHANISMS_COUNT = 6 | E-01 (136行目) | ○ |
| C-20 | STW時間数ミリ秒〜数十ミリ秒 | **根拠なし**（ベンチマーク参照推奨） | △ |
| C-21 | BGCスループット95%以上 | **根拠なし**（ベンチマーク参照推奨） | △ |
| C-22 | Regions対応（.NET 7〜） | **根拠なし**（リリースノート参照推奨） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス数値の具体的な測定データ
  - 候補：GCパフォーマンステスト / Microsoft公式ベンチマーク
- Regions機能の詳細実装
  - 候補：`src/coreclr/gc/gc.cpp` (FEATURE_REGIONS) / .NET 7リリースノート
- BGCアルゴリズムの詳細
  - 候補：`src/coreclr/gc/gc.cpp` / BOTR (Book of the Runtime)

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - gc.hの定数・列挙定義（ソースコードで確認可能）
- 1: 中リスク - パフォーマンス数値（ベンチマーク参照推奨）
- 1: 中リスク - 新機能（Regions）の説明（リリースノート参照推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] gc.hの世代定義がドキュメントの説明と一致しているか確認
- [ ] LARGE_OBJECT_SIZEの値が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] パフォーマンス数値についてMicrosoft公式ドキュメントと照合
- [ ] Regions機能について.NET 7リリースノートと照合
