---
generated_at: 2026-01-30 12:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：50-containers

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **ヘッダーファイル詳細**：.h APIインターフェース未読み込み
  2. **SIMDハッシュ詳細**：dn-simdhash実装の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `src/native/containers/dn-vector.c` - ベクター実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `src/native/containers/` ディレクトリ構造 - ファイル一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 汎用データ構造ライブラリ | E-02, E-03 | ○ |
| C-02 | INITIAL_CAPACITY = 64 | E-01 (28行目) | ○ |
| C-03 | CALC_NEW_CAPACITYマクロ | E-01 (29行目) | ○ |
| C-04 | element_offsetマクロ | E-01 (31-32行目) | ○ |
| C-05 | element_lengthマクロ | E-01 (34-35行目) | ○ |
| C-06 | check_attributeマクロ | E-01 (37行目) | ○ |
| C-07 | _dn_vector_ensure_capacity関数 | E-01 (39-75行目) | ○ |
| C-08 | UINT32_MAXオーバーフロー検査 | E-01 (50-51行目) | ○ |
| C-09 | dn_safe_size_t_multiplyオーバーフロー検査 | E-01 (53-55行目) | ○ |
| C-10 | dn_allocator_realloc呼び出し | E-01 (57行目) | ○ |
| C-11 | DN_VECTOR_ATTRIBUTE_MEMORY_INIT | E-01 (64行目) | ○ |
| C-12 | _dn_vector_insert_range関数 | E-01 (77-115行目) | ○ |
| C-13 | _dn_vector_append_range関数 | E-01 (117-138行目) | ○ |
| C-14 | _dn_vector_erase関数 | E-01 (140-170行目) | ○ |
| C-15 | _dn_vector_erase_fast関数 | E-01 (172-197行目) | ○ |
| C-16 | _dn_vector_custom_find関数 | E-01 (199-216行目) | ○ |
| C-17 | dn_vector_custom_alloc関数 | E-01 (218-232行目) | ○ |
| C-18 | dn_vector_custom_init関数 | E-01 (234-264行目) | ○ |
| C-19 | dn_vector_custom_free関数 | E-01 (266-276行目) | ○ |
| C-20 | dn_vector_custom_dispose関数 | E-01 (278-293行目) | ○ |
| C-21 | dn_vector_reserve関数 | E-01 (295-301行目) | ○ |
| C-22 | dn_vector_capacity関数 | E-01 (303-308行目) | ○ |
| C-23 | dn_vector_custom_resize関数 | E-01 (310-338行目) | ○ |
| C-24 | dn_vector_for_each関数 | E-01 (357-366行目) | ○ |
| C-25 | dn_vector_sort関数 | E-01 (368-379行目) | ○ |
| C-26 | qsort使用 | E-01 (378行目) | ○ |
| C-27 | ヘッダーファイルAPI詳細 | **根拠なし** - .h未読み込み | △ |
| C-28 | SIMDハッシュ実装詳細 | **根拠なし** - dn-simdhash.c詳細未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- ヘッダーファイル（API定義、マクロ、型定義）
  - 候補：src/native/containers/dn-vector.h
- SIMDハッシュテーブルの詳細実装
  - 候補：src/native/containers/dn-simdhash.c

## 5) リスクフラグ（レビュー観点）
- 0: 主張C-01〜C-26は低リスク（ソースコードで直接確認可能）
- 1: 主張C-27, C-28は中リスク（追加調査が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 容量成長計算式の説明は正確か
- [ ] オーバーフロー検査の説明は適切か
- [ ] メモリ管理（alloc/free/dispose）の説明は正確か
- [ ] ヘッダーファイルの追加調査が必要か判断
- [ ] SIMDハッシュの追加調査が必要か判断
