---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：51-minipal.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（8バイト/ループ）**：具体的なベンチマーク結果の根拠なし
  2. **セキュリティ考慮事項（XOR混入）**：コード上は確認できるが、セキュリティ設計意図の文書化なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/native/minipal/cpufeatures.h` - CPU機能フラグ定義
- E-02: `src/native/minipal/cpufeatures.c` - CPU機能検出実装（683行）
- E-03: `src/native/minipal/random.c` - 乱数生成実装（204行）
- E-04: `src/native/minipal/random.h` - 乱数生成関数宣言
- E-05: `src/native/minipal/utf8.c` - UTF-8変換実装（2152行）
- E-06: `src/native/minipal/utf8.h` - UTF-8変換関数宣言
- E-07: `src/native/minipal/guid.c` - GUID操作実装
- E-08: `src/native/minipal/mutex.c` - Mutex操作実装
- E-09: `src/native/minipal/time.c` - 時刻関数実装
- E-10: `src/native/minipal/debugger.c` - デバッガ検出実装
- E-11: `src/coreclr/minipal/minipal.h` - CoreCLR固有拡張
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | minipalは軽量プラットフォーム抽象化レイヤーである | E-12 | ○ |
| C-02 | Windows/Linux/macOS/iOS/Android/WebAssembly対応 | E-02, E-03 | ○ |
| C-03 | CPU機能検出（AVX、AVX2、AVX512、ARM NEON、SVE等） | E-01, E-02 (行14-59) | ○ |
| C-04 | minipal_getcpufeatures関数が存在する | E-02 (行219) | ○ |
| C-05 | BCryptGenRandomを使用（Windows） | E-03 (行102-103) | ○ |
| C-06 | CCRandomGenerateBytesを使用（macOS） | E-03 (行94-100) | ○ |
| C-07 | getrandomシステムコールを使用（Linux） | E-03 (行106-141) | ○ |
| C-08 | /dev/urandomへのフォールバック | E-03 (行144-200) | ○ |
| C-09 | UTF-8/UTF-16変換機能 | E-05 (行2059-2151) | ○ |
| C-10 | サロゲートペア処理 | E-05 (行18-33, 846-854) | ○ |
| C-11 | XArchIntrinsicConstants_Avx定義 | E-01 (行15) | ○ |
| C-12 | XArchIntrinsicConstants_Avx2定義 | E-01 (行16) | ○ |
| C-13 | XArchIntrinsicConstants_Avx512定義 | E-01 (行17) | ○ |
| C-14 | ARM64IntrinsicConstants_Aes定義 | E-01 (行36) | ○ |
| C-15 | ARM64IntrinsicConstants_Sve定義 | E-01 (行45) | ○ |
| C-16 | SSE2がサポートされていない場合Invalidフラグ設定 | E-02 (行241-251) | ○ |
| C-17 | EINTRでの自動リトライ | E-03 (行119-121) | ○ |
| C-18 | 置換文字U+FFFDの使用 | E-05 (行2068, 2112) | ○ |
| C-19 | MINIPAL_MB_NO_REPLACE_INVALID_CHARSフラグ | E-05 (行2069, 2113) | ○ |
| C-20 | Rosetta検出機能 | E-02 (行652-682) | ○ |
| C-21 | RISC-V対応（hwprobe syscall） | E-02 (行612-646) | ○ |
| C-22 | AVX10v1/v2サポート | E-02 (行416-448) | ○ |
| C-23 | APXサポート | E-02 (行407-413) | ○ |
| C-24 | 8バイト/ループの高速パス | E-05 | △ |
| C-25 | 非暗号論的乱数へのXOR混入 | E-03 (行60-69) | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値（8バイト/ループ）
  - 候補：ベンチマーク結果 / 設計仕様書 / コードコメント
- セキュリティ設計意図書
  - 候補：SECURITY.md / セキュリティレビュー文書 / 脅威モデル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要、データ構造定義
- 0: 低リスク - プラットフォーム固有実装
- 1: 中リスク - パフォーマンス要件（実測値の検証推奨）
- 1: 中リスク - セキュリティ考慮事項（セキュリティレビュー推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] CPU機能フラグの定義がソースコードと一致しているか確認
- [ ] 各プラットフォームの乱数生成APIが正しく記述されているか確認
- [ ] UTF-8変換のエラー処理が正確に記述されているか確認
- [ ] コードリーディングガイドの行番号が現在のコードと一致するか確認
- [ ] パフォーマンス要件の妥当性を検証（必要に応じてベンチマーク実施）
