---
generated_at: 2026-01-30 12:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：52-ilasm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **コマンドラインオプション詳細**：Options.csにはNoAutoInheritのみ定義、他のオプションの実装箇所未確認
  2. **maxstack検証ルール**：コードから明確な検証ロジックが確認できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tools/ilasm/src/ILAssembler/DocumentCompiler.cs` - コンパイル処理（59行）
- E-02: `src/tools/ilasm/src/ILAssembler/ILCompilation.cs` - コンパイル結果（21行）
- E-03: `src/tools/ilasm/src/ILAssembler/GrammarVisitor.cs` - 構文木ビジター
- E-04: `src/tools/ilasm/src/ILAssembler/Options.cs` - オプション定義（15行）
- E-05: `src/tools/ilasm/src/ILAssembler/PreprocessedTokenSource.cs` - プリプロセッサ
- E-06: `src/tools/ilasm/src/ILAssembler/EntityRegistry.cs` - エンティティ登録
- E-07: `src/tools/ilasm/src/ILAssembler/Diagnostic.cs` - 診断情報
- E-08: `src/tools/ilasm/src/ILAssembler/SourceText.cs` - ソースファイル表現
- E-09: `src/tools/ilasm/src/ILAssembler/TypeName.cs` - 型名表現
- E-10: `src/tools/ilasm/src/ILAssembler/InstructionEncoderExtensions.cs` - IL命令エンコード
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ilasmはILアセンブラである | E-11 | ○ |
| C-02 | CILソースコードをアセンブルする | E-01 | ○ |
| C-03 | ANTLR4を使用した構文解析 | E-01 (行11, 22, 45) | ○ |
| C-04 | DocumentCompiler.Compileがエントリーポイント | E-01 (行16-57) | ○ |
| C-05 | CILLexerによる字句解析 | E-01 (行22) | ○ |
| C-06 | CILParserによる構文解析 | E-01 (行45-46) | ○ |
| C-07 | GrammarVisitorによる構文木走査 | E-01 (行47-48), E-03 | ○ |
| C-08 | プリプロセッサでインクルード処理 | E-01 (行27-37), E-05 | ○ |
| C-09 | System.Reflection.Metadataでメタデータ生成 | E-01 (行9), E-03 (行80) | ○ |
| C-10 | System.Reflection.PortableExecutableでPE出力 | E-01 (行10) | ○ |
| C-11 | EntityRegistryでシンボル管理 | E-03 (行77), E-06 | ○ |
| C-12 | ImmutableArray<Diagnostic>で診断情報 | E-01 (行39), E-02 (行14) | ○ |
| C-13 | PEBuilderでPEファイル生成 | E-01 (行50, 56) | ○ |
| C-14 | Options.NoAutoInheritプロパティ | E-04 (行12) | ○ |
| C-15 | Portable PDBの生成サポート | E-03 (行98) | ○ |
| C-16 | ドキュメントハンドル管理 | E-03 (行97) | ○ |
| C-17 | typedef別名サポート | E-03 (行90) | ○ |
| C-18 | マップドフィールドデータ処理 | E-03 (行84-86) | ○ |
| C-19 | コマンドラインオプション（/dll, /exe等） | E-04 | △ |
| C-20 | maxstack検証ルール | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- コマンドラインオプション（/dll, /exe, /debug, /pdb等）の実装箇所
  - 候補：Program.cs（メインエントリ） / コマンドライン解析コード
- maxstack検証ロジックの実装
  - 候補：GrammarVisitor.cs内のメソッド処理部分

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要、基本アーキテクチャ
- 0: 低リスク - ANTLR4使用、System.Reflection.Metadata使用
- 1: 中リスク - コマンドラインオプション（実装確認推奨）
- 1: 中リスク - ビジネスルール（maxstack検証）

## 6) レビュアーチェックリスト（最小）
- [ ] DocumentCompiler.csのCompileメソッドが設計書の処理フローと一致するか確認
- [ ] GrammarVisitorの主要なVisitメソッドが存在するか確認
- [ ] ANTLR4文法ファイル（CIL.g4）が存在するか確認
- [ ] コマンドラインオプションの実装箇所を特定
- [ ] エラーメッセージ形式が設計書と一致するか確認
