---
generated_at: 2026-01-30 12:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：53-ildasm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **HTML/RTF出力機能**：コード内で出力形式の実装を確認できず
  2. **パフォーマンス要件**：具体的なベンチマーク結果の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/coreclr/ildasm/dasm.cpp` - メイン処理、グローバル変数（多数の行）
- E-02: `src/coreclr/ildasm/dis.h` - 関数宣言、定数定義（160行）
- E-03: `src/coreclr/ildasm/dis.cpp` - IL命令デコード
- E-04: `src/coreclr/ildasm/ceeload.cpp` - PEファイルローダー
- E-05: `src/coreclr/ildasm/ceeload.h` - PELoaderクラス定義
- E-06: `src/coreclr/ildasm/dman.cpp` - マニフェスト処理
- E-07: `src/coreclr/ildasm/dasm_formattype.cpp` - 型フォーマット
- E-08: `src/coreclr/ildasm/dynamicarray.h` - 動的配列テンプレート
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ildasmはIL逆アセンブラである | E-09 | ○ |
| C-02 | PEファイルを解析しILソースを出力 | E-01, E-02 | ○ |
| C-03 | g_pImportグローバル変数でIMDInternalImport管理 | E-01 (行52) | ○ |
| C-04 | g_pPELoaderでPELoader管理 | E-01 (行55) | ○ |
| C-05 | g_fDumpILフラグでIL出力制御 | E-01 (行73) | ○ |
| C-06 | g_fDumpHeaderフラグでヘッダ出力制御 | E-01 (行74) | ○ |
| C-07 | g_fShowBytesフラグでバイト表示制御 | E-01 (行87) | ○ |
| C-08 | g_fShowSourceフラグでソース行表示制御 | E-01 (行88) | ○ |
| C-09 | ISymUnmanagedReaderでシンボル読取 | E-01 (行50) | ○ |
| C-10 | MAX_CLASSNAME_LENGTH=1024 | E-02 (行7) | ○ |
| C-11 | MAX_MEMBER_LENGTH=1024 | E-02 (行8) | ○ |
| C-12 | SZSTRING_SIZE=131072 | E-02 (行146) | ○ |
| C-13 | Disassemble関数の存在 | E-02 (行20) | ○ |
| C-14 | DecodeOpcode関数の存在 | E-02 (行22) | ○ |
| C-15 | DumpMethod関数の存在 | E-02 (行49) | ○ |
| C-16 | DumpClass関数の存在 | E-02 (行54) | ○ |
| C-17 | DumpHeader関数の存在 | E-02 (行64) | ○ |
| C-18 | DumpManifest関数の存在 | E-02 (行123) | ○ |
| C-19 | LineCodeDescr構造体でデバッグ行情報表現 | E-02 (行23-31) | ○ |
| C-20 | g_fProjectフラグでWinMD変換制御 | E-01 (行104) | ○ |
| C-21 | HTML/RTF出力形式サポート | E-02 (行127-128) | △ |
| C-22 | パフォーマンス要件（数秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- HTML/RTF出力の詳細実装
  - 候補：dasm.cpp内の出力処理 / windasm.cpp
- パフォーマンスベンチマーク結果
  - 候補：テストレポート / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要、グローバル変数定義
- 0: 低リスク - 関数宣言、定数定義
- 1: 中リスク - HTML/RTF出力（実装確認推奨）
- 1: 中リスク - バッファサイズ制限によるセキュリティ（SZSTRING_SIZE）
- 2: 高リスク - レガシーC++コードのバッファ安全性

## 6) レビュアーチェックリスト（最小）
- [ ] dasm.cppのグローバル変数が設計書の記述と一致するか確認
- [ ] dis.hの関数宣言が設計書と一致するか確認
- [ ] Disassemble/DecodeOpcode関数の実装を確認
- [ ] バッファオーバーフロー対策（CHECK_REMAINING_SIZE等）を確認
- [ ] HTML/RTF出力の実装箇所を特定
