---
generated_at: 2026-01-30 12:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：54-illink.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **トリミング警告コード一覧**：全コードの網羅性未確認
  2. **パフォーマンス要件**：具体的なベンチマーク結果の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tools/illink/src/linker/Linker/LinkContext.cs` - リンカーコンテキスト
- E-02: `src/tools/illink/src/linker/Linker/Driver.cs` - メインドライバ
- E-03: `src/tools/illink/src/linker/Linker.Steps/MarkStep.cs` - マーキング処理
- E-04: `src/tools/illink/src/linker/Linker.Steps/SweepStep.cs` - 削除処理
- E-05: `src/tools/illink/src/linker/Linker.Steps/CleanStep.cs` - クリーンアップ
- E-06: `src/tools/illink/src/linker/Linker.Steps/OutputStep.cs` - 出力処理
- E-07: `src/tools/illink/src/linker/Linker/AssemblyAction.cs` - アクション定義
- E-08: `src/tools/illink/src/linker/Linker/TypePreserve.cs` - 保持レベル
- E-09: `src/tools/illink/src/linker/Linker.Steps/IStep.cs` - ステップインターフェース
- E-10: `src/tools/illink/src/linker/Linker.Steps/ResolveFromXmlStep.cs` - XMLルート解決
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | illinkは未使用コードをトリミング | E-11 | ○ |
| C-02 | LinkContextクラスが全体状態を管理 | E-01 (行62) | ○ |
| C-03 | Pipelineプロパティの存在 | E-01 (行81-84) | ○ |
| C-04 | AnnotationStoreの存在 | E-01 (行73, 90) | ○ |
| C-05 | MarkStepがIStepを実装 | E-03 (行51) | ○ |
| C-06 | メソッドキュー管理 | E-03 (行63) | ○ |
| C-07 | インターフェースメソッド追跡 | E-03 (行64) | ○ |
| C-08 | SweepStepがBaseStepを継承 | E-04 (行43) | ○ |
| C-09 | sweepSymbolsフラグ | E-04 (行45) | ○ |
| C-10 | Process()メソッドの存在 | E-04 (行52) | ○ |
| C-11 | RemoveUnmarkedAssembly呼び出し | E-04 (行59) | ○ |
| C-12 | UpdateAssemblyReferencesToRemovedAssemblies | E-04 (行63) | ○ |
| C-13 | AssemblyAction.Link | E-04 (行72) | ○ |
| C-14 | AssemblyAction.CopyUsed | E-04 (行71) | ○ |
| C-15 | AssemblyAction.Save | E-04 (行73) | ○ |
| C-16 | SweepAssemblyReferences | E-04 (行74) | ○ |
| C-17 | TypeMapHandler | E-03 (行78) | ○ |
| C-18 | compilerGeneratedMethodRequiresScanner | E-03 (行76) | ○ |
| C-19 | UnreachableBlocksOptimizer | E-01 (行79) | ○ |
| C-20 | ErrorsCountプロパティ | E-01 (行94) | ○ |
| C-21 | OutputDirectoryプロパティ | E-01 (行96) | ○ |
| C-22 | MetadataTrimmingプロパティ | E-01 (行98) | ○ |
| C-23 | 警告コード体系（IL2xxx） | E-02 | △ |
| C-24 | パフォーマンス要件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- トリミング警告コードの完全な一覧
  - 候補：ILLink.Shared/DiagnosticId.cs / ドキュメント
- パフォーマンスベンチマーク結果
  - 候補：テストレポート / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要、クラス構造
- 0: 低リスク - ステップパイプライン構成
- 1: 中リスク - 警告コード一覧（網羅性確認推奨）
- 1: 中リスク - データフロー解析の精度
- 2: 高リスク - リフレクション使用時のトリミング安全性

## 6) レビュアーチェックリスト（最小）
- [ ] LinkContext.csのプロパティが設計書と一致するか確認
- [ ] MarkStep/SweepStepの処理フローが設計書と一致するか確認
- [ ] AssemblyActionの列挙値が設計書と一致するか確認
- [ ] 警告コード（IL2xxx）の一覧を補完
- [ ] 実際のトリミング結果を検証
