---
generated_at: 2026-01-30 12:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：55-StressLogAnalyzer.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **StressLogHeader構造体定義**：詳細な構造体定義ファイルの確認必要
  2. **環境変数設定方法**：COMPLUS_StressLog設定の詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tools/StressLogAnalyzer/src/Program.cs` - メインプログラム（593行）
- E-02: `src/tools/StressLogAnalyzer/src/StressLogAnalyzer.cs` - 解析コア
- E-03: `src/tools/StressLogAnalyzer/src/Options.cs` - オプション定義
- E-04: `src/tools/StressLogAnalyzer/src/Filters/` - フィルタ実装
- E-05: `src/tools/StressLogAnalyzer/src/Output/` - 出力実装
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メモリマップドファイルからログ読み取り | E-01 (行347) | ○ |
| C-02 | System.CommandLineでCLI解析 | E-01 (行6-8) | ○ |
| C-03 | Main()でコマンドライン解析 | E-01 (行57-88) | ○ |
| C-04 | CreateRootCommand()でオプション定義 | E-01 (行100-343) | ○ |
| C-05 | InputFileArgumentの定義 | E-01 (行90-93) | ○ |
| C-06 | SingleRunOptionの定義 | E-01 (行95-98) | ○ |
| C-07 | valueRangesオプション | E-01 (行108-144) | ○ |
| C-08 | timeRangesオプション | E-01 (行146-170) | ○ |
| C-09 | levelFilterオプション | E-01 (行182-217) | ○ |
| C-10 | gcIndexオプション | E-01 (行225-244) | ○ |
| C-11 | threadFilterオプション | E-01 (行267-277) | ○ |
| C-12 | Parallel.ForEachAsyncで並列処理 | E-02 (行55) | ○ |
| C-13 | CreateMessageFilter()でフィルタチェーン | E-01 (行446-473) | ○ |
| C-14 | magic "LRTS"でヘッダ検証 | E-01 (行482) | ○ |
| C-15 | バージョン0x00010001/0x00010002サポート | E-01 (行483) | ○ |
| C-16 | ContractDescriptorTarget.Create() | E-01 (行492-500) | ○ |
| C-17 | インタラクティブモード（q/r） | E-01 (行70-85) | ○ |
| C-18 | PrintFooter()でサマリー出力 | E-01 (行406-444) | ○ |
| C-19 | StressLogHeader構造体の詳細 | E-01 | △ |
| C-20 | 環境変数COMPLUS_StressLog | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- StressLogHeader構造体の完全な定義
  - 候補：StressLogHeader.cs / ランタイムソースコード
- COMPLUS_StressLog環境変数の設定方法
  - 候補：ランタイムドキュメント / 環境変数一覧

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドラインオプション定義
- 0: 低リスク - フィルタチェーン構築
- 1: 中リスク - StressLogHeader構造体の整合性
- 1: 中リスク - 並列処理の正確性

## 6) レビュアーチェックリスト（最小）
- [ ] Program.csのコマンドラインオプションが設計書と一致するか確認
- [ ] StressLogAnalyzer.csのAnalyzeLogsAsync処理フローを確認
- [ ] フィルタクラスの実装を確認
- [ ] StressLogHeader構造体定義を確認
- [ ] 実際のストレスログファイルでの動作検証
