---
generated_at: 2026-01-30 12:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 12
  claims_without_evidence: 3
confidence_derived: 0.80
---

# 根拠レポート：56-SharedFramework.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：12 / 15、根拠なし：3
- 優先レビュー（高）
  1. **ロールフォワードポリシー詳細**：hostfxrソースでの実装確認必要
  2. **エラーコード一覧**：SDK/ホストのエラーコード体系の確認必要
  3. **パッケージ出力構造**：sfxprojファイルの詳細確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/Subsets.props` - SharedFrameworkProjectToBuild定義（行706-735）
- E-02: `eng/liveBuilds.targets` - SharedFrameworkDir定義（行26-28, 89-95）
- E-03: `eng/Version.Details.props` - バージョン定義（行61, 175）
- E-04: `Directory.Build.targets` - TestHostSharedFrameworkPath（行38）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SharedFrameworkは共有フレームワーク | E-05 | ○ |
| C-02 | SharedFrameworkProjectToBuildの存在 | E-01 (行706) | ○ |
| C-03 | Microsoft.NETCore.App.Ref.sfxproj | E-01 (行706) | ○ |
| C-04 | Microsoft.NETCore.App.Crossgen2.sfxproj | E-01 (行709) | ○ |
| C-05 | dotnet-host.proj | E-01 (行710) | ○ |
| C-06 | dotnet-hostfxr.proj | E-01 (行711) | ○ |
| C-07 | Microsoft.NETCore.App.Host.sfxproj | E-01 (行728) | ○ |
| C-08 | Microsoft.NETCore.App.Runtime.CoreCLR.sfxproj | E-01 (行729) | ○ |
| C-09 | Microsoft.NETCore.App.Runtime.Mono.sfxproj | E-01 (行730) | ○ |
| C-10 | CoreCLRSharedFrameworkDir定義 | E-02 (行26, 92) | ○ |
| C-11 | LibrariesSharedFrameworkDir定義 | E-02 (行27, 93) | ○ |
| C-12 | HostSharedFrameworkDir定義 | E-02 (行28, 94) | ○ |
| C-13 | ロールフォワードポリシー | **根拠なし** | △ |
| C-14 | エラーコードNETSDK1045/1061 | **根拠なし** | △ |
| C-15 | ディレクトリ構造詳細 | E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- ロールフォワードポリシーの実装詳細
  - 候補：hostfxr/fx_resolver.cpp / runtime_config.cpp
- SDKエラーコードの定義
  - 候補：SDKソースコード / Microsoft.NET.Sdk
- 実際のパッケージ出力内容
  - 候補：ビルド成果物 / sfxprojファイル詳細

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ビルド定義ファイルの参照
- 1: 中リスク - ロールフォワードポリシー（実装確認推奨）
- 1: 中リスク - エラーコード（SDK確認推奨）
- 1: 中リスク - パッケージ構造（実際の出力確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] Subsets.propsのSharedFrameworkProjectToBuildが設計書と一致するか確認
- [ ] liveBuilds.targetsのパス定義を確認
- [ ] sfxprojファイルの存在と内容を確認
- [ ] ロールフォワードポリシーの実装を確認
- [ ] 実際のSharedFrameworkディレクトリ構造を確認
