---
generated_at: 2026-01-30 13:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：57-HostFxr.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **ステータスコード一覧**：error_codes.hでの完全な定義確認必要
  2. **エクスポート関数一覧**：hostfxr.hでの完全な宣言確認必要
  3. **フレームワーク検索パス**：実装での検索順序確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/native/corehost/fxr/hostfxr.cpp` - エクスポート関数実装（150行以上）
- E-02: `src/native/corehost/fxr/fx_muxer.cpp` - マルチプレクサ実装
- E-03: `src/native/corehost/fxr/fx_resolver.cpp` - フレームワーク解決
- E-04: `src/native/corehost/fxr/runtime_config.cpp` - 設定解析
- E-05: `src/native/corehost/fxr/sdk_resolver.cpp` - SDK解決
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HostFxrはフレームワーク解決を行う | E-06 | ○ |
| C-02 | hostfxr_main_bundle_startupinfo関数 | E-01 (行30-49) | ○ |
| C-03 | hostfxr_main_startupinfo関数 | E-01 (行52-64) | ○ |
| C-04 | hostfxr_main関数 | E-01 (行66-74) | ○ |
| C-05 | trace_hostfxr_entry_point呼び出し | E-01 (行22-28, 32, 54, 68) | ○ |
| C-06 | host_startup_info_t構造体使用 | E-01 (行47, 62, 70) | ○ |
| C-07 | fx_muxer_t::execute呼び出し | E-01 (行48, 63, 73) | ○ |
| C-08 | bundle::info_t::process_bundle | E-01 (行34) | ○ |
| C-09 | StatusCode::InvalidArgFailure | E-01 (行44, 59) | ○ |
| C-10 | StatusCode::Success | E-01 | ○ |
| C-11 | hostfxr_resolve_sdk非推奨 | E-01 (行76-77) | ○ |
| C-12 | fx_resolver使用 | E-01 (行10) | ○ |
| C-13 | runtime_config使用 | E-01 (行12) | ○ |
| C-14 | sdk_resolver使用 | E-01 (行14) | ○ |
| C-15 | sdk_info使用 | E-01 (行13) | ○ |
| C-16 | 全エクスポート関数一覧 | E-01 | △ |
| C-17 | 全ステータスコード一覧 | E-01 | △ |
| C-18 | フレームワーク検索パス詳細 | E-03 | △ |

## 4) 不足情報（Unknown / Missing）
- 完全なエクスポート関数一覧
  - 候補：hostfxr.h / hostfxr.cpp全体
- 完全なステータスコード一覧
  - 候補：error_codes.h
- フレームワーク検索パスの実装詳細
  - 候補：fx_resolver.cpp / multilevel_lookup.cpp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要エントリーポイント関数
- 0: 低リスク - 基本的な処理フロー
- 1: 中リスク - エクスポート関数一覧（網羅性確認推奨）
- 1: 中リスク - ステータスコード（完全性確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] hostfxr.cppのエントリーポイント関数が設計書と一致するか確認
- [ ] fx_muxer_t::execute()の呼び出しフローを確認
- [ ] error_codes.hからステータスコード一覧を補完
- [ ] hostfxr.hからエクスポート関数一覧を補完
- [ ] フレームワーク解決の詳細フローを確認
