---
generated_at: 2026-01-30 13:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：58-HostPolicy.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **CoreCLRプロパティ一覧**：coreclr_properties設定の完全な確認必要
  2. **エクスポート関数一覧**：hostpolicy.hでの完全な宣言確認必要
  3. **依存関係解決詳細**：deps_resolver.cppの実装詳細確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/native/corehost/hostpolicy/hostpolicy.cpp` - エクスポート関数実装（100行以上）
- E-02: `src/native/corehost/hostpolicy/deps_resolver.h` - 依存関係解決器宣言
- E-03: `src/native/corehost/hostpolicy/coreclr.cpp` - CoreCLR操作
- E-04: `src/native/corehost/hostpolicy/hostpolicy_context.cpp` - コンテキスト管理
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HostPolicyはアセンブリ読み込みポリシーを担当 | E-05 | ○ |
| C-02 | g_init_lockグローバル変数 | E-01 (行28) | ○ |
| C-03 | g_init_doneグローバル変数 | E-01 (行29) | ○ |
| C-04 | g_initグローバル変数 | E-01 (行30) | ○ |
| C-05 | g_context_lockグローバル変数 | E-01 (行34) | ○ |
| C-06 | g_contextグローバル変数 | E-01 (行39) | ○ |
| C-07 | g_context_initializingグローバル変数 | E-01 (行45) | ○ |
| C-08 | create_coreclr関数 | E-01 (行48-97) | ○ |
| C-09 | coreclr_t::create呼び出し | E-01 (行75-80) | ○ |
| C-10 | StatusCode::HostInvalidState | E-01 (行56) | ○ |
| C-11 | StatusCode::CoreClrInitFailure | E-01 (行85) | ○ |
| C-12 | StatusCode::Success | E-01 (行89) | ○ |
| C-13 | g_context_initializing_cv使用 | E-01 (行46, 95) | ○ |
| C-14 | coreclr_properties.log_properties | E-01 (行67) | ○ |
| C-15 | app_domain_friendly_name設定 | E-01 (行71) | ○ |
| C-16 | CoreCLRプロパティ一覧 | E-01 | △ |
| C-17 | 全エクスポート関数一覧 | E-01 | △ |
| C-18 | 依存関係解決詳細ロジック | E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- 完全なCoreCLRプロパティ一覧
  - 候補：coreclr_properties.cpp / hostpolicy_context.cpp
- 完全なエクスポート関数一覧
  - 候補：hostpolicy.h
- deps_resolver詳細実装
  - 候補：deps_resolver.cpp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - グローバル変数定義
- 0: 低リスク - 基本的なエラーコード
- 1: 中リスク - CoreCLRプロパティ（完全性確認推奨）
- 1: 中リスク - エクスポート関数（網羅性確認推奨）
- 1: 中リスク - 依存関係解決（実装詳細確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] hostpolicy.cppのグローバル変数が設計書と一致するか確認
- [ ] create_coreclr関数のフローを確認
- [ ] CoreCLRプロパティの完全な一覧を補完
- [ ] hostpolicy.hからエクスポート関数一覧を補完
- [ ] deps_resolver.cppの解決ロジックを確認
