---
generated_at: 2026-01-30 13:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 12
  claims_without_evidence: 4
confidence_derived: 0.75
---

# 根拠レポート：59-WebAssemblyWorkload.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.75**
  - 根拠あり：12 / 16、根拠なし：4
- 優先レビュー（高）
  1. **MSBuildプロパティ一覧**：WasmApp.propsでの完全な定義確認必要
  2. **ビルド成果物構造**：実際のビルド出力確認必要
  3. **エラーコード一覧**：SDKエラーコードの確認必要
  4. **ワークロードインストールコマンド**：最新のコマンド確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/mono/wasm/build/WasmApp.targets` - ビルドターゲット（存在確認済）
- E-02: `src/mono/wasm/Wasm.Build.Tests/WasmBuildAppBase.cs` - テスト基底クラス
- E-03: `src/mono/wasm/Wasm.Build.Tests/Blazor/BlazorWasmTestBase.cs` - Blazorテスト
- E-04: `src/mono/wasm/Wasm.Build.Tests/Common/BuildEnvironment.cs` - ビルド環境
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebAssembly WorkloadはBlazor WebAssembly開発をサポート | E-05 | ○ |
| C-02 | wasm-toolsワークロードの存在 | E-04 | ○ |
| C-03 | WasmApp.targetsの存在 | E-01 | ○ |
| C-04 | WasmBuildAppBase.csの存在 | E-02 | ○ |
| C-05 | BlazorWasmTestBase.csの存在 | E-03 | ○ |
| C-06 | Blazorテスト関連ファイルの存在 | E-03 | ○ |
| C-07 | ICUシャーディングテスト | E-02周辺 | ○ |
| C-08 | AOTコンパイルテスト | E-02周辺 | ○ |
| C-09 | ネイティブビルドテスト | E-02周辺 | ○ |
| C-10 | SIMD関連テスト | E-02周辺 | ○ |
| C-11 | テンプレートテスト | E-02周辺 | ○ |
| C-12 | 国際化テスト | E-02周辺 | ○ |
| C-13 | MSBuildプロパティ完全一覧 | E-01 | △ |
| C-14 | ビルド成果物構造詳細 | **根拠なし** | △ |
| C-15 | エラーコード一覧 | **根拠なし** | △ |
| C-16 | ワークロードインストールコマンド | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 完全なMSBuildプロパティ一覧
  - 候補：WasmApp.props / WasmApp.targets
- ビルド成果物の実際の構造
  - 候補：実際のビルド出力 / テスト検証コード
- SDKエラーコード定義
  - 候補：Microsoft.NET.Sdk / エラーメッセージリソース
- ワークロードマニフェスト
  - 候補：workloads/wasm-tools/WorkloadManifest.json

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要
- 0: 低リスク - テストファイルの存在
- 1: 中リスク - MSBuildプロパティ（完全性確認推奨）
- 1: 中リスク - ビルド成果物構造（実際の出力確認推奨）
- 2: 高リスク - エラーコード（SDK確認必要）

## 6) レビュアーチェックリスト（最小）
- [ ] WasmApp.targetsの内容を確認
- [ ] WasmApp.propsのプロパティ定義を確認
- [ ] 実際のBlazor WebAssemblyビルド出力を確認
- [ ] ワークロードマニフェストを確認
- [ ] MSBuildプロパティ一覧を補完
