---
generated_at: 2026-01-30 12:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 17
  claims_without_evidence: 3
confidence_derived: 0.85
---

# 根拠レポート：6-インタープリター.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：17 / 20、根拠なし：3
- 優先レビュー（高）
  1. **実行速度JITの1/10〜1/100**：ベンチマーク根拠確認推奨
  2. **Monoインタープリターとの差異**：実装比較推奨
  3. **Tiered Compilation連携詳細**：実装詳細確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/coreclr/interpreter/compiler.cpp` - インタープリターコンパイラ
- E-02: `src/coreclr/interpreter/interpreter.h` - インタープリターヘッダ
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | インタープリターはJIT不可環境向け | E-03 | ○ |
| C-02 | g_stackTypeFromInterpTypeテーブル定義 | E-01 (12-25行目) | ○ |
| C-03 | g_interpTypeFromStackTypeテーブル定義 | E-01 (27-38行目) | ○ |
| C-04 | t_InterpJitInfoTlsスレッドローカル変数 | E-01 (41行目) | ○ |
| C-05 | g_stackTypeString配列 | E-01 (43行目) | ○ |
| C-06 | IsInterpDumpActive()関数 | E-01 (52-59行目) | ○ |
| C-07 | AssertOpCodeNotImplemented()関数 | E-01 (61-69行目) | ○ |
| C-08 | InterpIAllocatorクラス | E-01 (71-80行目) | ○ |
| C-09 | StackTypeI4〜StackTypeVT型定義 | E-01 (14-24行目) | ○ |
| C-10 | InterpTypeI4〜InterpTypeByRef型定義 | E-01 (29-37行目) | ○ |
| C-11 | MITライセンス | E-01 (1-2行目) | ○ |
| C-12 | GCInfoEncoder連携 | E-01 (3行目 gcinfoencoder.h) | ○ |
| C-13 | ICorJitInfo*型使用 | E-01 (41行目) | ○ |
| C-14 | 画面No.2との関連（Advanced Sample） | E-04 | ○ |
| C-15 | CEEDecodeOpcode関数使用 | E-01 (66行目) | ○ |
| C-16 | BADCODE呼び出し | E-01 (68行目) | ○ |
| C-17 | DEBUG条件コンパイル | E-01 (48-50行目) | ○ |
| C-18 | 実行速度JITの1/10〜1/100 | **根拠なし**（ベンチマーク参照推奨） | △ |
| C-19 | Monoインタープリターとの差異詳細 | **根拠なし**（実装比較推奨） | △ |
| C-20 | Tiered Compilation連携詳細 | **根拠なし**（実装詳細確認推奨） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス比較データ（JIT vs インタープリター）
  - 候補：ベンチマークスイート / パフォーマンステスト
- Monoインタープリターとの実装差異
  - 候補：`src/mono/mono/mini/interp/interp.c` との比較
- Tiered Compilationとの連携フロー
  - 候補：`src/coreclr/vm/tieredcompilation.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - compiler.cppの型変換テーブル（ソースコードで確認可能）
- 1: 中リスク - パフォーマンス数値（ベンチマーク参照推奨）
- 1: 中リスク - 他コンポーネントとの連携（実装確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] compiler.cppのスタック型マッピングがドキュメントの説明と一致しているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] InterpIAllocatorの実装が正確に反映されているか確認
- [ ] パフォーマンス数値についてベンチマークデータと照合
- [ ] Monoインタープリターとの差異について追加情報の補完を検討
