---
generated_at: 2026-01-30 13:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 10
  claims_without_evidence: 5
confidence_derived: 0.67
---

# 根拠レポート：60-iOSWorkload.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.67**
  - 根拠あり：10 / 15、根拠なし：5
- 優先レビュー（高）
  1. **MSBuildプロパティ一覧**：iOS固有のビルドプロパティ確認必要
  2. **エラーコード一覧**：MTエラーコードの完全な定義確認必要
  3. **ビルド成果物構造**：実際のビルド出力確認必要
  4. **コード署名設定**：詳細な署名プロセス確認必要
  5. **ワークロードインストールコマンド**：最新コマンド確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/mono/sample/iOS/Program.cs` - iOSサンプルプログラム
- E-02: `src/tasks/AppleAppBuilder/` - アプリバンドルビルダー（ディレクトリ存在確認）
- E-03: `src/tasks/MonoTargetsTasks/MonoAOTCompiler.cs` - AOTコンパイラタスク
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | iOS Workloadは.NET MAUI/Xamarin.iOS開発をサポート | E-04 | ○ |
| C-02 | iOSサンプルプログラムの存在 | E-01 | ○ |
| C-03 | AppleAppBuilderの存在 | E-02 | ○ |
| C-04 | MonoAOTCompilerの存在 | E-03 | ○ |
| C-05 | AOTコンパイルが必須 | E-03 | ○ |
| C-06 | サポートされるRID一覧 | E-01周辺 | ○ |
| C-07 | .NET MAUIとの統合 | E-04 | ○ |
| C-08 | Xcodeツールチェイン使用 | E-02 | ○ |
| C-09 | MonoランタイムベースのiOS実行 | E-01 | ○ |
| C-10 | LLVMを使用したAOT | E-03 | ○ |
| C-11 | MSBuildプロパティ完全一覧 | **根拠なし** | △ |
| C-12 | エラーコード一覧（MT0xxx） | **根拠なし** | △ |
| C-13 | ビルド成果物構造詳細 | **根拠なし** | △ |
| C-14 | コード署名プロセス詳細 | **根拠なし** | △ |
| C-15 | ワークロードインストールコマンド | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 完全なMSBuildプロパティ一覧
  - 候補：iOS.targets / Apple.props
- MTエラーコード定義
  - 候補：Xamarin.iOS / .NET MAUI SDKソース
- ビルド成果物の実際の構造
  - 候補：実際のビルド出力 / AppleAppBuilder実装
- コード署名プロセスの詳細
  - 候補：Apple Developer ドキュメント / codesign実装
- ワークロードマニフェスト
  - 候補：workloads/ios/WorkloadManifest.json

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要
- 0: 低リスク - サンプルとタスクの存在
- 1: 中リスク - MSBuildプロパティ（完全性確認推奨）
- 2: 高リスク - エラーコード（MTエラー体系の確認必要）
- 2: 高リスク - コード署名（セキュリティ関連のため詳細確認必要）

## 6) レビュアーチェックリスト（最小）
- [ ] iOSサンプルプログラムの内容を確認
- [ ] AppleAppBuilderタスクの実装を確認
- [ ] MonoAOTCompilerのiOS対応を確認
- [ ] iOS固有のMSBuildプロパティ一覧を補完
- [ ] MTエラーコードの定義を確認
- [ ] 実際のiOSビルド出力を検証
