---
generated_at: 2026-01-30 12:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：61-Androidワークロード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値基準がコード内に明示されていない
  2. **リリースビルド署名**：デバッグキー以外の署名方法の詳細仕様

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tasks/AndroidAppBuilder/AndroidAppBuilderTask.cs`
- E-02: `src/tasks/AndroidAppBuilder/ApkBuilder.cs`
- E-03: `src/tasks/AndroidAppBuilder/AndroidLibBuilderTask.cs`
- E-04: `src/mono/msbuild/android/build/AndroidBuild.props`
- E-05: `src/mono/msbuild/android/build/AndroidBuild.targets`
- E-06: `src/mono/nuget/Microsoft.NET.Workload.Mono.Toolchain.Current.Manifest/WorkloadManifest.json.in`
- E-07: `src/mono/sample/Android/AndroidSampleApp.csproj`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RuntimeFlavorEnumはMono/CoreCLR/NativeAOTの3種類を定義 | E-02（17-22行目） | ○ |
| C-02 | デフォルトのMinApiLevelは21 | E-02（26行目：DefaultMinApiLevel = "21"） | ○ |
| C-03 | デフォルトのTargetApiLevelは31 | E-02（27行目：DefaultTargetApiLevel = "31"） | ○ |
| C-04 | AOTとインタープリターは同時に有効化できない | E-02（117-120行目） | ○ |
| C-05 | DiagnosticPorts使用時はdiagnostics_tracingが必要 | E-02（122-125行目） | ○ |
| C-06 | Android SDKはANDROID_SDK_ROOT環境変数から取得可能 | E-02（97-100行目） | ○ |
| C-07 | Android NDKはANDROID_NDK_ROOT環境変数から取得可能 | E-02（102-105行目） | ○ |
| C-08 | ProjectNameにスペースを含むとエラー | E-02（92-95行目） | ○ |
| C-09 | パッケージIDは"net.dot.{ProjectName}"形式 | E-02（426行目） | ○ |
| C-10 | APKサイズがログ出力される | E-02（584行目） | ○ |
| C-11 | 出力APKパスは{OutputDir}/bin/{ProjectName}.apk | E-02（576行目） | ○ |
| C-12 | RuntimeIdentifierの必須パラメータ属性 | E-01（77行目：[Required]） | ○ |
| C-13 | AppDirの必須パラメータ属性 | E-01（18行目：[Required]） | ○ |
| C-14 | OutputDirの必須パラメータ属性 | E-01（80行目：[Required]） | ○ |
| C-15 | ワークロードで対応するプラットフォーム一覧 | E-06（56行目：platforms配列） | ○ |
| C-16 | Androidランタイムパックの種類（arm/arm64/x64/x86） | E-06（50-53行目） | ○ |
| C-17 | AndroidBuildDependsOnのターゲット順序 | E-04（21-38行目） | ○ |
| C-18 | AndroidAppBuilderTaskの呼び出しパラメータ | E-05（250-272行目） | ○ |
| C-19 | サンプルアプリのRuntimeFlavorデフォルトはMono | E-07（3行目） | ○ |
| C-20 | ForceAOTオプションのサポート | E-07（10行目）、E-01（44行目） | ○ |
| C-21 | RunAOTCompilationオプションのサポート | E-07（11行目）、E-05（174行目） | ○ |
| C-22 | 機能名「Androidワークロード」の定義 | E-08（62行目） | ○ |
| C-23 | StaticLinkedRuntimeオプションのサポート | E-01（64行目）、E-02（46行目） | ○ |
| C-24 | パフォーマンス要件（AOTコンパイル時間） | **根拠なし** | △ |
| C-25 | リリースビルド署名の詳細仕様 | **根拠不足**（KeyStorePathのみ確認） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（AOTコンパイル時間の具体的数値）
  - 候補：ベンチマーク結果 / CI/CDログ / パフォーマンステスト仕様書
- リリースビルド用の正式署名手順
  - 候補：ドキュメント / 外部Android署名ガイド / MSBuildプロパティ定義

## 5) リスクフラグ（レビュー観点）
- 0: RuntimeFlavorEnum定義 - コード内で明確に定義
- 0: APIレベルデフォルト値 - コード定数で確認済み
- 0: ビルドターゲット順序 - MSBuildファイルで定義済み
- 1: パフォーマンス要件 - 定性的記述のみ、定量的基準なし
- 1: リリース署名 - デバッグキー以外の詳細手順が不明確

## 6) レビュアーチェックリスト（最小）
- [ ] RuntimeFlavorEnum（Mono/CoreCLR/NativeAOT）が正しく記載されているか
- [ ] 入力パラメータのデフォルト値（MinApiLevel=21、TargetApiLevel=31）が正確か
- [ ] AOT/インタープリター排他制御のロジックがコードと一致しているか
- [ ] ビルドターゲットの依存関係がAndroidBuild.propsと一致しているか
- [ ] 対応プラットフォーム一覧がWorkloadManifest.json.inと一致しているか
- [ ] パフォーマンス要件の記述が適切か（具体的数値がない点を確認）
