---
generated_at: 2026-01-30 12:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：62-WASIワークロード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **WASIp2仕様の完全対応範囲**：実装されているWASI APIの完全なリストが明示されていない
  2. **パフォーマンス比較**：AOT vs インタープリターの具体的な性能差

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.CoreLib/src/System/Threading/Wasi/WasiEventLoop.cs`
- E-02: `src/libraries/System.Net.Http/src/System/Net/Http/WasiHttpHandler/WasiHttpHandler.cs`
- E-03: `src/mono/nuget/Microsoft.NET.Workload.Mono.Toolchain.Current.Manifest/WorkloadManifest.json.in`
- E-04: `src/mono/wasm/templates/templates/wasi-console/wasi-console.0.csproj`
- E-05: `src/mono/sample/wasi/console/Wasi.Console.Sample.csproj`
- E-06: `src/mono/sample/wasi/http-p2/Wasip2.Http.Console.Sample.csproj`
- E-07: `src/mono/wasi/Wasi.Build.Tests/BuildTestBase.cs`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WasiEventLoopでPollableを管理 | E-01（17-18行目：s_pollables、s_hooks） | ○ |
| C-02 | PollWasiEventLoopUntilResolvedがメインループ | E-01（52-73行目） | ○ |
| C-03 | CheckPollablesでPollInterop.Pollを呼び出し | E-01（156行目） | ○ |
| C-04 | PollableHolderでTaskCompletionSourceを使用 | E-01（201行目、213行目） | ○ |
| C-05 | WasiHttpHandlerはHttpMessageHandlerを継承 | E-02（145行目） | ○ |
| C-06 | SendAsyncでWasiRequestWrapperを使用 | E-02（155-166行目） | ○ |
| C-07 | WasiRequestWrapperでOutgoingRequestを構築 | E-02（38-43行目） | ○ |
| C-08 | FutureIncomingResponseでレスポンスを待機 | E-02（51行目、87行目） | ○ |
| C-09 | wasi-experimentalワークロードの定義 | E-03（27-36行目） | ○ |
| C-10 | WASIワークロードが含むパック一覧 | E-03（29-34行目） | ○ |
| C-11 | 対応プラットフォーム一覧 | E-03（36行目：platforms配列） | ○ |
| C-12 | RuntimeIdentifierはwasi-wasm | E-04（4行目） | ○ |
| C-13 | OutputTypeはExe | E-04（5行目） | ○ |
| C-14 | PublishTrimmed=true推奨 | E-04（6行目）、E-05（12行目） | ○ |
| C-15 | _WasiNeedsHttpフラグの存在 | E-06（4行目） | ○ |
| C-16 | WasmBuildNativeオプション | E-05（13行目） | ○ |
| C-17 | WASI_SDK_PATH環境変数が必須 | E-07（66-68行目） | ○ |
| C-18 | DefaultTargetFrameworkの定義 | E-07（29-30行目：net11.0） | ○ |
| C-19 | BuildEnvironment.DefaultRuntimeIdentifier | E-07（471行目） | ○ |
| C-20 | 機能名「WASIワークロード」の定義 | E-08（63行目） | ○ |
| C-21 | WASIソケットサポート | E-06（ファイル存在確認） | ○ |
| C-22 | extends配列にmicrosoft-net-runtime-mono-tooling | E-03（35行目） | ○ |
| C-23 | WASIp2で実装されている全APIの範囲 | **根拠不足** | △ |
| C-24 | AOT vs インタープリターのパフォーマンス比較 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- WASIp2で実装されている全APIの完全リスト
  - 候補：WITファイル / WASI仕様書 / 実装済みInteropファイル一覧
- AOT vs インタープリターのパフォーマンス比較データ
  - 候補：ベンチマーク結果 / CI/CDログ / パフォーマンステスト仕様書

## 5) リスクフラグ（レビュー観点）
- 0: WasiEventLoop実装 - コード内で明確に実装
- 0: WasiHttpHandler実装 - コード内で明確に実装
- 0: ワークロードマニフェスト - JSON定義で確認済み
- 1: WASIp2 API対応範囲 - 網羅的なリストが不明
- 1: パフォーマンス要件 - 定量的基準なし
- 0: 実験的機能 - wasi-experimentalとして明示されている

## 6) レビュアーチェックリスト（最小）
- [ ] WasiEventLoopのPollable管理ロジックがコードと一致しているか
- [ ] WasiHttpHandlerのSendAsyncフローがコードと一致しているか
- [ ] wasi-experimentalワークロードの構成がマニフェストと一致しているか
- [ ] WASI_SDK_PATH必須の記述が正確か
- [ ] 対応プラットフォーム一覧がWorkloadManifest.json.inと一致しているか
- [ ] WASIp2対応範囲の記述が実装と整合しているか（要追加調査）
