---
generated_at: 2026-01-30 11:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があるため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/mono/sample/wasm/browser/wwwroot/index.html`
- E-02: `src/mono/sample/wasm/browser-advanced/wwwroot/index.html`
- E-03: `src/mono/sample/wasm/browser-threads/wwwroot/index.html`
- E-04: `src/mono/sample/wasm/browser-shutdown/wwwroot/index.html`
- E-05: `src/mono/sample/wasm/browser-bench/wwwroot/index.html`
- E-06: `src/mono/sample/wasm/browser-profile/wwwroot/index.html`
- E-07: `src/mono/sample/wasm/browser-logprofile/wwwroot/index.html`
- E-08: `src/mono/sample/wasm/browser-eventpipe/wwwroot/index.html`
- E-09: `src/mono/sample/wasm/simple-raytracer/wwwroot/index.html`
- E-10: `src/mono/sample/mbr/browser/wwwroot/index.html`
- E-11: `src/mono/wasm/templates/templates/browser/wwwroot/index.html`
- E-12: `src/mono/wasm/testassets/WasmBasicTestApp/App/wwwroot/index.html`
- E-13: `src/mono/wasm/testassets/LibraryMode/wwwroot/index.html`
- E-14: `src/mono/wasm/testassets/WasmBrowserRunMainOnly/wwwroot/index.html`
- E-15: `src/mono/wasm/testassets/WasmOnAspNetCore/WasmBrowserClient/wwwroot/index.html`
- E-16: `src/mono/wasm/testassets/BlazorBasicTestApp/App/wwwroot/index.html`
- E-17: `src/mono/wasm/testassets/WasmOnAspNetCore/BlazorClient/wwwroot/index.html`
- E-18: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Home.razor`
- E-19: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Counter.razor`
- E-20: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/Home.razor`
- E-21: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm.Client/Pages/Counter.razor`
- E-22: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/Error.razor`
- E-23: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/NotFound.razor`
- E-24: `src/mono/wasm/testassets/WasmOnAspNetCore/BlazorClient/Pages/Chat.razor`
- E-25: `src/tests/FunctionalTests/WebAssembly/Browser/HotReload/index.html`
- E-26: `src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig/index.html`
- E-27: `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/index.html`
- E-28: `src/tests/Common/wasm-test-runner/index.html`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Wasm Browser Sample 画面が存在し、titleが「Wasm Browser Sample」 | E-01 | ○ |
| C-02 | Wasm Browser Advanced Sample 画面が存在し、CSP設定あり | E-02 | ○ |
| C-03 | Wasm Browser Threading Sample 画面が存在し、進捗表示あり | E-03 | ○ |
| C-04 | Wasm Browser Shutdown Sample 画面が存在し、各種ボタンあり | E-04 | ○ |
| C-05 | Benchmark Sample 画面が存在する | E-05 | ○ |
| C-06 | Profiler Sample 画面が存在する | E-06 | ○ |
| C-07 | Log Profiler Sample 画面が存在する | E-07 | ○ |
| C-08 | EventPipe Profiling Sample 画面が存在し、Say Hiボタンあり | E-08 | ○ |
| C-09 | Simple Wasm Raytracer 画面が存在し、640x480 Canvasあり | E-09 | ○ |
| C-10 | Hot Reload Sample 画面が存在し、Updateボタンあり | E-10 | ○ |
| C-11 | Stopwatch テンプレート画面が存在し、Pause/Resetボタンあり | E-11 | ○ |
| C-12 | WasmBasicTestApp エントリーポイントが存在する | E-12 | ○ |
| C-13 | LibraryMode テスト画面が存在する | E-13 | ○ |
| C-14 | WasmBrowserRunMainOnly テスト画面が存在する | E-14 | ○ |
| C-15 | WasmBrowser（ASP.NET Core統合）画面が存在する | E-15 | ○ |
| C-16 | BlazorBasicTestApp エントリーポイントが存在する | E-16 | ○ |
| C-17 | BlazorHosted（ASP.NET Core統合）画面が存在する | E-17 | ○ |
| C-18 | Home.razor（BlazorBasicTestApp）がルート/で定義されている | E-18 | ○ |
| C-19 | Counter.razor（BlazorBasicTestApp）がルート/counterで定義されている | E-19 | ○ |
| C-20 | Home.razor（BlazorWebWasm）がルート/で定義されている | E-20 | ○ |
| C-21 | Counter.razor（BlazorWebWasm）がルート/counterでInteractiveWebAssemblyモード | E-21 | ○ |
| C-22 | Error.razor（BlazorWebWasm）がルート/Errorで定義されている | E-22 | ○ |
| C-23 | NotFound.razor（BlazorWebWasm）がルート/not-foundで定義されている | E-23 | ○ |
| C-24 | Chat.razor（WasmOnAspNetCore）がルート/でSignalRテスト実行 | E-24 | ○ |
| C-25 | Wasm HotReload Test 画面が存在する | E-25 | ○ |
| C-26 | Runtime Config Test（RuntimeConfig）画面が存在する | E-26 | ○ |
| C-27 | Runtime Config Test（StartupHook）画面が存在する | E-27 | ○ |
| C-28 | Wasm Test Runner 画面が存在する | E-28 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に対して根拠が存在するため、不足情報はありません。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての画面情報はソースコードから直接抽出されており、高い信頼性があります。
- 注意点:
  - 本プロジェクトは .NET Runtime のライブラリ/ランタイムのソースコードであり、エンドユーザー向けアプリケーションではありません
  - 記載された画面はサンプル、テンプレート、テストアセットであり、プロダクション用の画面ではありません
  - OSXインストーラーのHTMLファイル（welcome.html, conclusion.html等）は画面一覧から除外しています（インストーラーUI用のため）

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧CSVの項目数（28件）が妥当か確認
- [ ] 各カテゴリ（Wasmサンプル、Blazorテストアセット等）の分類が適切か確認
- [ ] テンプレートファイルパスが実際のファイルと一致しているか抜き打ち確認
- [ ] Blazorページのルート定義（@page ディレクティブ）が正確か確認
- [ ] 画面遷移図のフローがアプリケーションの実際の動作と一致しているか確認
