# 画面遷移図

本プロジェクトは .NET Runtime のソースコードリポジトリであり、主にサンプルアプリケーションとテストアセットとして画面（HTML/Razor）が存在します。各サンプル/テストアセットは独立して動作するため、アプリケーション間の画面遷移は存在しません。

以下は、各アプリケーション内での画面遷移を示します。

## 1. BlazorBasicTestApp 画面遷移図

```mermaid
flowchart TD
    subgraph BlazorBasicTestApp["BlazorBasicTestApp"]
        BBTA_Entry["index.html<br/>エントリーポイント"]
        BBTA_Home["Home.razor<br/>ホームページ<br/>ルート: /"]
        BBTA_Counter["Counter.razor<br/>カウンターページ<br/>ルート: /counter"]

        BBTA_Entry --> BBTA_Home
        BBTA_Home <--> BBTA_Counter
    end
```

## 2. BlazorWebWasm 画面遷移図

```mermaid
flowchart TD
    subgraph BlazorWebWasm["BlazorWebWasm"]
        BWW_Home["Home.razor<br/>ホームページ<br/>ルート: /"]
        BWW_Counter["Counter.razor<br/>カウンターページ<br/>ルート: /counter"]
        BWW_Error["Error.razor<br/>エラーページ<br/>ルート: /Error"]
        BWW_NotFound["NotFound.razor<br/>404ページ<br/>ルート: /not-found"]

        BWW_Home <--> BWW_Counter
        BWW_Home -.->|エラー発生時| BWW_Error
        BWW_Counter -.->|エラー発生時| BWW_Error
        BWW_Home -.->|存在しないURL| BWW_NotFound
    end
```

## 3. WasmOnAspNetCore 画面遷移図

```mermaid
flowchart TD
    subgraph WasmOnAspNetCore["WasmOnAspNetCore"]
        subgraph WasmBrowserClient["WasmBrowserClient"]
            WBC_Entry["index.html<br/>WasmBrowser"]
        end

        subgraph BlazorClient["BlazorClient"]
            BC_Entry["index.html<br/>BlazorHosted"]
            BC_Chat["Chat.razor<br/>チャットルーム<br/>ルート: /"]

            BC_Entry --> BC_Chat
        end
    end
```

## 4. Wasm サンプルアプリケーション（単一画面）

以下のサンプルはすべて単一画面で完結しています。

```mermaid
flowchart LR
    subgraph WasmSamples["Wasm サンプル（各独立）"]
        S1["Wasm Browser Sample"]
        S2["Browser Advanced Sample"]
        S3["Browser Threading Sample"]
        S4["Browser Shutdown Sample"]
        S5["Benchmark Sample"]
        S6["Profiler Sample"]
        S7["Log Profiler Sample"]
        S8["EventPipe Sample"]
        S9["Simple Raytracer"]
        S10["Hot Reload Sample"]
        S11["Stopwatch Template"]
    end
```

## 5. 機能テスト・テストランナー

```mermaid
flowchart LR
    subgraph FunctionalTests["機能テスト（各独立）"]
        FT1["HotReload Test"]
        FT2["RuntimeConfig Test"]
        FT3["StartupHook Test"]
    end

    subgraph TestInfra["テストインフラ"]
        TR["Wasm Test Runner"]
    end
```

## 遷移の説明

### BlazorBasicTestApp
- **Home** (`/`): アプリケーションのトップページ。ナビゲーションメニューからCounterへ遷移可能
- **Counter** (`/counter`): カウンター機能を持つページ。ボタンクリックでカウントが増加

### BlazorWebWasm
- **Home** (`/`): アプリケーションのトップページ
- **Counter** (`/counter`): InteractiveWebAssemblyモードで動作するカウンターページ
- **Error** (`/Error`): エラー発生時に表示されるページ
- **Not Found** (`/not-found`): 存在しないURLにアクセスした際に表示される404ページ

### WasmOnAspNetCore
- **BlazorClient/Chat** (`/`): SignalRを使用したチャット機能のテストページ
- **WasmBrowserClient**: 単純なWasmクライアント画面

### 単一画面アプリケーション
これらのサンプルとテストは、特定の機能をデモンストレーションまたはテストするための単一画面アプリケーションです。
- 各画面は独立して動作
- 画面間の遷移は存在しない
- それぞれが特定の .NET WebAssembly 機能を検証する目的で作成
