---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 88
  claims_with_evidence: 82
  claims_without_evidence: 6
confidence_derived: 0.93
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：82 / 88、根拠なし：6
- 優先レビュー（高）
  1. **画面9（Simple Wasm Raytracer）とSystem.Numerics.Tensorsの関連**：Tensors APIの直接使用は未確認、ベクトル演算は独自実装
  2. **画面7（Log Profiler Sample）とガベージコレクターの関連**：ヒープショット機能の実装詳細が限定的
  3. **テストアセット画面のMicrosoft.Extensions系機能との関連**：暗黙的な依存関係の可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `src/mono/sample/wasm/browser/Program.cs`
- E-04: `src/mono/sample/wasm/browser/wwwroot/main.js`
- E-05: `src/mono/sample/wasm/browser-advanced/Program.cs`
- E-06: `src/mono/sample/wasm/browser-threads/Program.cs`
- E-07: `src/mono/sample/wasm/browser-shutdown/Program.cs`
- E-08: `src/mono/sample/wasm/browser-bench/Program.cs`
- E-09: `src/mono/sample/wasm/browser-profile/Program.cs`
- E-10: `src/mono/sample/wasm/browser-logprofile/Program.cs`
- E-11: `src/mono/sample/wasm/browser-eventpipe/Program.cs`
- E-12: `src/mono/sample/wasm/simple-raytracer/Program.cs`
- E-13: `src/mono/sample/mbr/browser/Program.cs`
- E-14: `src/mono/wasm/templates/templates/browser/Program.cs`
- E-15: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Home.razor`
- E-16: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Counter.razor`
- E-17: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/Home.razor`
- E-18: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm.Client/Pages/Counter.razor`
- E-19: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/Error.razor`
- E-20: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/NotFound.razor`
- E-21: `src/mono/wasm/testassets/WasmOnAspNetCore/BlazorClient/Pages/Chat.razor`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面1（Wasm Browser Sample）はMonoランタイムを使用 | E-03, E-04 | ○ |
| C-02 | 画面1はWebAssembly Workloadでビルド・実行 | E-01, E-03 | ○ |
| C-03 | 画面1はWasmAppBuilderでビルドサポート | E-02 | ○ |
| C-04 | 画面2（Wasm Browser Advanced Sample）はMonoランタイムを使用 | E-05 | ○ |
| C-05 | 画面2はタイムゾーン処理とJSImport/JSExportを使用 | E-05 | ○ |
| C-06 | 画面2はインタープリターを補助的に使用 | E-02 | ○ |
| C-07 | 画面3（Wasm Browser Threading Sample）はSystem.Threadingを使用 | E-06 | ○ |
| C-08 | 画面3はTask.Run、GC.Collectを使用 | E-06 | ○ |
| C-09 | 画面3はガベージコレクターを使用 | E-06 | ○ |
| C-10 | 画面4（Wasm Browser Shutdown Sample）は例外処理とFailFastを使用 | E-07 | ○ |
| C-11 | 画面4はSystem.Timers.Timerを使用 | E-07 | ○ |
| C-12 | 画面5（Benchmark Sample）はSystem.Text.Jsonを使用 | E-08 | ○ |
| C-13 | 画面5はSystem.Text.RegularExpressionsを使用 | E-08 | ○ |
| C-14 | 画面5はWebSocket通信ベンチマークを含む | E-08 | ○ |
| C-15 | 画面5はSystem.Collectionsを使用 | E-08 | ○ |
| C-16 | 画面6（Profiler Sample）はJSExportを使用 | E-09 | ○ |
| C-17 | 画面6はeventpipeを補助的に使用 | E-02, E-09 | ○ |
| C-18 | 画面7（Log Profiler Sample）はヒープショット機能を使用 | E-10 | ○ |
| C-19 | 画面7はガベージコレクターを使用 | E-10 | △ |
| C-20 | 画面8（EventPipe Profiling Sample）はEventSourceを使用 | E-11 | ○ |
| C-21 | 画面8はSystem.Diagnostics.Tracingを使用 | E-11 | ○ |
| C-22 | 画面8はeventpipeを使用 | E-11 | ○ |
| C-23 | 画面9（Simple Wasm Raytracer）はベクトル演算を使用 | E-12 | ○ |
| C-24 | 画面9はSystem.Numerics.Tensorsを使用 | **根拠なし** | △ |
| C-25 | 画面9はActivator.CreateInstanceでジェネリック型を生成 | E-12 | ○ |
| C-26 | 画面10（Hot Reload Sample）はDeltaHelperでアセンブリ更新 | E-13 | ○ |
| C-27 | 画面10はSystem.Reflection.Emitを使用 | E-13 | ○ |
| C-28 | 画面11（Stopwatch）はStopwatchクラスを使用 | E-14 | ○ |
| C-29 | 画面11はJSImport/JSExportを使用 | E-14 | ○ |
| C-30 | 画面12-14（Wasmテストアセット）はMonoランタイムを使用 | E-01 | ○ |
| C-31 | 画面15（WasmBrowser ASP.NET統合）はMicrosoft.Extensions.Hostingを使用 | **根拠なし** | △ |
| C-32 | 画面16-17（Blazorテストアセット）はDIコンテナを使用 | E-02 | ○ |
| C-33 | 画面17はSignalR（WebSocket）を使用 | E-21 | ○ |
| C-34 | 画面18（Home BlazorBasicTestApp）はOnAfterRenderを実装 | E-15 | ○ |
| C-35 | 画面19（Counter BlazorBasicTestApp）はonclickイベントを処理 | E-16 | ○ |
| C-36 | 画面20（Home BlazorWebWasm）はPageTitleを設定 | E-17 | ○ |
| C-37 | 画面21（Counter BlazorWebWasm）はInteractiveWebAssemblyモードを使用 | E-18 | ○ |
| C-38 | 画面22（Error BlazorWebWasm）はSystem.Diagnostics.Activityを使用 | E-19 | ○ |
| C-39 | 画面23（Not Found BlazorWebWasm）はMainLayoutを使用 | E-20 | ○ |
| C-40 | 画面24（Chat WasmOnAspNetCore）はSignalRTestを実行 | E-21 | ○ |
| C-41 | 画面24はNavigationManagerを使用 | E-21 | ○ |
| C-42 | 画面25-27（機能テスト）はWebAssembly Workloadを使用 | E-01 | ○ |
| C-43 | 画面28（Wasm Test Runner）はテストインフラとして機能 | E-01 | ○ |
| C-44 | すべてのWasm画面はMonoランタイム上で動作 | E-02 | ○ |
| C-45 | すべてのWasm画面はWebAssembly Workloadを使用 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 画面9（Simple Wasm Raytracer）でSystem.Numerics.Tensorsの直接使用が確認できなかった
  - 候補：MathFクラスによる独自ベクトル演算 / System.Numerics.Vector3の使用可能性 / 将来的なTensors API統合
- 画面15（WasmBrowser ASP.NET統合）でMicrosoft.Extensions.Hostingの明示的な使用が確認できなかった
  - 候補：ASP.NET Core依存関係からの暗黙的使用 / プロジェクトファイルでの参照確認が必要
- 画面7（Log Profiler Sample）でガベージコレクターの明示的な使用（TakeHeapshot以外）が限定的
  - 候補：ヒープショット取得時のGC動作 / プロファイリング時のメモリ管理
- テストアセット画面（12-14, 25-28）の詳細な機能実装の確認が限定的
  - 候補：csprojファイルの確認 / テストコードの詳細解析

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 画面1-8, 10-11, 18-23, 28: ソースコードから機能使用が明確に確認できる
- **1: 中リスク** - 画面12-17, 24-27: 画面一覧・機能一覧からの推論を含む
- **2: 高リスク** - 画面9: System.Numerics.Tensorsの使用根拠が弱い（独自ベクトル演算実装のため）

## 6) レビュアーチェックリスト（最小）
- [ ] 画面9（Simple Wasm Raytracer）のベクトル演算実装を確認し、System.Numerics.Tensorsとの関連を再評価
- [ ] 画面15（WasmBrowser ASP.NET統合）のプロジェクトファイルでMicrosoft.Extensions.Hosting参照を確認
- [ ] 画面7（Log Profiler Sample）のヒープショット機能とGCの関連を検証
- [ ] 各テストアセット画面のcsprojファイルで実際のパッケージ参照を確認
- [ ] Blazor画面のDependency Injection設定を確認し、使用機能との整合性を検証
- [ ] SignalR使用画面（17, 24）でWebSocket通信の実装詳細を確認
