# 画面設計書 12-WasmBasicTestApp

## 概要

本ドキュメントは、Wasm基本テストアプリケーションのエントリーポイント画面の設計書です。この画面は、WebAssemblyの各種機能テストを実行するためのテストハーネスとして機能します。

### 本画面の処理概要

この画面では、クエリパラメータで指定されたテストケースに応じて、WebAssemblyの様々な機能をテストできます。サテライトアセンブリ、遅延読み込み、環境変数、プロファイリングなど、多岐にわたるWebAssembly機能の検証を一つのエントリーポイントから実行できます。

**業務上の目的・背景**：本画面は、.NET WebAssemblyランタイムの品質保証のために必要なテストアセットです。開発者やCI/CDパイプラインがWebAssembly機能の動作確認を行う際に使用されます。各テストケースは独立して実行可能で、URLのクエリパラメータによってテスト対象を切り替えることができます。これにより、特定機能の回帰テストや新機能の検証を効率的に行えます。

**画面へのアクセス方法**：ブラウザでアプリケーションのルートURLにアクセスし、`?test=テストケース名`形式のクエリパラメータでテストを指定します。例：`index.html?test=SatelliteAssembliesTest`

**主要な操作・処理内容**：
1. クエリパラメータからテストケース名を取得
2. テストケースに応じたランタイム設定を適用
3. WebAssemblyランタイムを初期化
4. 指定されたテスト処理を実行
5. テスト結果をコンソールまたはDOM要素に出力

**画面遷移**：この画面は単一画面テストアプリケーションのため、他画面への遷移はありません。

**権限による表示制御**：認証・権限機能は実装されていません。テスト用アセットのため、すべてのテストが実行可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | WebAssemblyランタイム上でテストアプリを実行 |
| 59 | WebAssembly Workload | 主機能 | WebAssemblyアプリケーションのビルドと実行をサポート |
| 40 | WasmAppBuilder | 補助機能 | WebAssemblyテストアプリのビルドサポート |

## 画面種別

テスト実行画面（テストハーネス）

## URL/ルーティング

- パス: `/index.html?test={テストケース名}`
- テンプレートファイル: `src/mono/wasm/testassets/WasmBasicTestApp/App/wwwroot/index.html`

### サポートされるテストケース

| テストケース名 | 説明 |
|--------------|------|
| SatelliteAssembliesTest | サテライトアセンブリのロードテスト |
| LazyLoadingTest | 遅延読み込み機能のテスト |
| AppSettingsTest | アプリケーション設定のテスト |
| FilesToIncludeInFileSystemTest | 仮想ファイルシステムのテスト |
| DownloadResourceProgressTest | リソースダウンロード進捗のテスト |
| AssetIntegrity | アセット整合性チェックのテスト |
| OutErrOverrideWorks | stdout/stderr オーバーライドのテスト |
| InterpPgoTest | インタープリターPGOのテスト |
| DownloadThenInit | ダウンロード後初期化のテスト |
| MaxParallelDownloads | 並列ダウンロード制限のテスト |
| AllocateLargeHeapThenInterop | 大規模ヒープ割り当てテスト |
| LogProfilerTest | ログプロファイラーのテスト |
| EnvVariablesTest | 環境変数のテスト |
| BrowserProfilerTest | ブラウザプロファイラーのテスト |
| HttpNoStreamingTest | 非ストリーミングHTTPテスト |
| OverrideBootConfigName | ブート設定名オーバーライドテスト |
| MainWithArgs | 引数付きMain関数テスト |

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 |
|--------|----------|-----|------|
| test | 入力（クエリ） | string | 実行するテストケース名 |
| out | 出力 | string | テスト結果を表示するspan要素 |

## 表示項目

| 項目名 | 説明 | 初期値 |
|--------|------|--------|
| 出力領域 | テスト結果を表示するspan要素（id="out"） | 空 |

## イベント仕様

### 1-ページロード時のテスト実行

**トリガー**: ページロード完了後、main.jsモジュールが実行される

**処理フロー**:
1. URLクエリパラメータからtestパラメータを取得
2. testパラメータが未指定の場合、exit(2)でエラー終了
3. テストケースに応じたdotnetランタイム設定を適用
4. dotnet.create()でランタイムを初期化
5. getAssemblyExportsでC#のエクスポート関数を取得
6. テストケースに対応する処理を実行
7. exit()で終了コードを返す

**結果**: テスト結果がコンソールおよびDOM要素に出力される

## データベース更新仕様

本画面ではデータベース操作は行いません。テスト結果はメモリ上で処理され、コンソールに出力されます。

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|---------------|---------|---------------|
| エラー | テストケース未指定 | "Missing test scenario. Supply query argument 'test'." |
| コンソール出力 | テスト開始時 | "not ready yet" / "ready" |
| コンソール出力 | テスト完了時 | "done" |
| テスト出力 | 各テスト内 | "TestOutput -> {メッセージ}" |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| テストケース未指定 | exit(2)でエラー終了、エラーメッセージを表示 |
| 未知のテストケース | exit(3)でエラー終了 |
| テスト実行中の例外 | ExitStatus以外の場合はexit(1)でエラー終了 |

## 備考

- 本画面はWebAssemblyランタイムの機能テスト用アセットです
- CI/CDパイプラインでの自動テスト実行に使用されます
- 各テストケースは独立して実行可能です
- profiler.jsでプロファイリングデータの保存機能を提供します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テストケースの種類と対応する設定を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.js | `src/mono/wasm/testassets/WasmBasicTestApp/App/wwwroot/main.js` | switch文でテストケース別の設定と実行処理を定義 |

**読解のコツ**: main.jsは2つのswitch文を持ち、最初のswitch（39-184行目）はランタイム設定、2番目のswitch（193-372行目）はテスト実行を制御します。

#### Step 2: エントリーポイントを理解する

JavaScriptエントリーポイントの初期化処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.js | `src/mono/wasm/testassets/WasmBasicTestApp/App/wwwroot/main.js` | クエリパラメータ解析とランタイム初期化 |

**主要処理フロー**:
1. **4-5行目**: dotnetモジュールとプロファイラーをインポート
2. **8-12行目**: URLクエリパラメータからテストケース名を取得、未指定時はexit(2)
3. **24行目**: dotnet.withConfig()で基本設定を適用
4. **39-184行目**: テストケース別のランタイム設定
5. **186行目**: dotnet.create()でランタイム初期化
6. **193-372行目**: テストケース別の実行処理

#### Step 3: C#側のテスト処理を理解する

テストケースに対応するC#クラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Program.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/Common/Program.cs` | メインエントリーポイント |
| 3-2 | SatelliteAssembliesTest.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/SatelliteAssembliesTest.cs` | サテライトアセンブリテスト |
| 3-3 | LazyLoadingTest.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/LazyLoadingTest.cs` | 遅延読み込みテスト |
| 3-4 | EnvVariablesTest.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/EnvVariablesTest.cs` | 環境変数テスト |

**主要処理フロー**:
- **Program.cs 4行目**: コンソールに"WasmBasicTestApp"を出力
- 各テストクラスは`[JSExport]`属性付きの静的メソッドを公開

#### Step 4: HTMLテンプレートを理解する

画面構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.html | `src/mono/wasm/testassets/WasmBasicTestApp/App/wwwroot/index.html` | 最小限のHTML構造。出力用span要素のみ |

**主要処理フロー**:
- **13-14行目**: main.jsとprofiler.jsをモジュールとして読み込み
- **18行目**: id="out"のspan要素でテスト結果を表示

### プログラム呼び出し階層図

```
main.js (エントリーポイント)
    │
    ├─ URLSearchParams (テストケース取得)
    │
    ├─ dotnet.withConfig() (基本設定)
    │
    ├─ [テストケース別設定 switch]
    │      ├─ SatelliteAssembliesTest: loadAllSatelliteResources設定
    │      ├─ LazyLoadingTest: diagnosticTracing有効化
    │      ├─ InterpPgoTest: インタープリターPGO設定
    │      ├─ LogProfilerTest: logProfilerOptions設定
    │      └─ ... (その他テストケース)
    │
    ├─ dotnet.create() (ランタイム初期化)
    │
    ├─ getAssemblyExports() (C#エクスポート取得)
    │
    └─ [テスト実行 switch]
           ├─ exports.SatelliteAssembliesTest.Run()
           ├─ exports.LazyLoadingTest.Run()
           ├─ exports.EnvVariablesTest.DumpVariables()
           └─ ... (その他テスト)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

URLクエリ               JavaScript                     テスト結果
?test=xxx    ───▶    main.js                   ───▶    console.log
                          │                             │
                          ▼                             ▼
                    dotnet.create()                 #out span
                          │
                          ▼
                    C# Test Class
                    [JSExport]
                          │
                          ▼
                    テストロジック実行
                          │
                          ▼
                    exit(code)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/mono/wasm/testassets/WasmBasicTestApp/App/wwwroot/index.html` | テンプレート | 画面構造を定義するHTMLファイル |
| main.js | `src/mono/wasm/testassets/WasmBasicTestApp/App/wwwroot/main.js` | ソース | テストハーネスのメインロジック |
| profiler.js | `src/mono/wasm/testassets/WasmBasicTestApp/App/wwwroot/profiler.js` | ソース | プロファイリングデータ保存機能 |
| Program.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/Common/Program.cs` | ソース | C#エントリーポイント |
| SatelliteAssembliesTest.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/SatelliteAssembliesTest.cs` | ソース | サテライトアセンブリテスト |
| LazyLoadingTest.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/LazyLoadingTest.cs` | ソース | 遅延読み込みテスト |
| EnvVariablesTest.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/EnvVariablesTest.cs` | ソース | 環境変数テスト |
| LogProfilerTest.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/LogProfilerTest.cs` | ソース | ログプロファイラーテスト |
| BrowserProfilerTest.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/BrowserProfilerTest.cs` | ソース | ブラウザプロファイラーテスト |
| InterpPgoTest.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/InterpPgoTest.cs` | ソース | インタープリターPGOテスト |
| HttpTest.cs | `src/mono/wasm/testassets/WasmBasicTestApp/App/HttpTest.cs` | ソース | HTTPテスト |
| WasmBasicTestApp.csproj | `src/mono/wasm/testassets/WasmBasicTestApp/App/WasmBasicTestApp.csproj` | 設定 | プロジェクト設定 |
