# 画面設計書 13-LibraryMode

## 概要

本ドキュメントは、Wasmライブラリモードのテスト用画面の設計書です。この画面は、WebAssemblyをライブラリとして使用する際の動作を検証するためのテストアセットです。

### 本画面の処理概要

この画面では、.NET WebAssemblyをライブラリモードで実行し、Main関数を持たないWebAssemblyモジュールからJavaScriptへ関数をエクスポートする機能を検証します。ライブラリモードは、WebAssemblyをスタンドアロンアプリケーションではなく、JavaScriptから呼び出される関数ライブラリとして使用するケースに対応します。

**業務上の目的・背景**：本画面は、.NET WebAssemblyのライブラリモード機能をテストするためのアセットです。ライブラリモードでは、C#で作成した関数をJavaScriptから直接呼び出せるようにエクスポートします。これにより、既存のJavaScriptアプリケーションに.NETの機能を組み込むシナリオをサポートします。OutputTypeがLibraryに設定されたプロジェクトの動作検証に使用されます。

**画面へのアクセス方法**：ブラウザでアプリケーションのルートURL（index.html）に直接アクセスすることで画面が表示されます。画面には視覚的なUIは表示されず、処理結果はコンソールに出力されます。

**主要な操作・処理内容**：
1. dotnet.create()でWebAssemblyランタイムを初期化（Main関数は実行しない）
2. getAssemblyExportsでC#のエクスポート関数を取得
3. エクスポートされたMyExport()関数を呼び出し
4. 戻り値をコンソールに出力

**画面遷移**：この画面は単一画面テストアプリケーションのため、他画面への遷移はありません。

**権限による表示制御**：認証・権限機能は実装されていません。テスト用アセットのため、すべての機能が実行可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | WebAssemblyライブラリモードでのランタイム実行 |
| 59 | WebAssembly Workload | 主機能 | WebAssemblyアプリケーションのビルドと実行をサポート |
| 40 | WasmAppBuilder | 補助機能 | WebAssemblyライブラリのビルドサポート |

## 画面種別

テスト実行画面（ライブラリモードテスト）

## URL/ルーティング

- パス: `/index.html`
- テンプレートファイル: `src/mono/wasm/testassets/LibraryMode/wwwroot/index.html`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 |
|--------|----------|-----|------|
| なし | - | - | 画面にUI要素はなし |

## 表示項目

| 項目名 | 説明 | 初期値 |
|--------|------|--------|
| なし | 画面にはbody要素のみ、表示項目なし | - |

## イベント仕様

### 1-ページロード時の処理

**トリガー**: ページロード完了後、main.jsモジュールが実行される

**処理フロー**:
1. dotnetモジュールをインポート
2. dotnet.create()でWebAssemblyランタイムを初期化
3. getConfig()で設定情報を取得
4. getAssemblyExports()でC#のエクスポート関数を取得
5. exports.LibraryMode.Test.MyExport()を呼び出し
6. 戻り値（100）をコンソールに`WASM EXIT {code}`形式で出力

**結果**: コンソールに "TestOutput -> WASM Library MyExport is called" と "WASM EXIT 100" が出力される

## データベース更新仕様

本画面ではデータベース操作は行いません。

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|---------------|---------|---------------|
| コンソール出力 | C#関数実行時 | "TestOutput -> WASM Library MyExport is called" |
| コンソール出力 | 処理完了時 | "WASM EXIT 100" |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| ランタイム初期化失敗 | ブラウザのデフォルトエラー表示 |
| エクスポート関数取得失敗 | JavaScript例外がスローされる |

## 備考

- 本画面はWebAssemblyライブラリモードのテスト用アセットです
- OutputTypeがLibraryに設定されているため、Main関数は存在しません
- JSExport属性を使用してC#関数をJavaScriptに公開します
- dotnet.runMain()は呼び出されません（ライブラリモードの特徴）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ライブラリモードでエクスポートされる関数の構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LibraryMode.cs | `src/mono/wasm/testassets/LibraryMode/LibraryMode.cs` | JSExport属性付きのMyExportメソッドの定義 |

**読解のコツ**: ライブラリモードでは、`[JSExport]`属性を付けたメソッドのみがJavaScriptから呼び出し可能になります。

#### Step 2: エントリーポイントを理解する

JavaScriptエントリーポイントの処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.js | `src/mono/wasm/testassets/LibraryMode/wwwroot/main.js` | dotnet.create()のみで初期化し、runMain()を呼び出さない点が重要 |

**主要処理フロー**:
1. **4行目**: dotnetモジュールをインポート
2. **6行目**: dotnet.create()でランタイムを初期化（awaitで完了待ち）
3. **8行目**: getConfig()で設定を取得
4. **9行目**: getAssemblyExports()でC#エクスポートを取得
5. **10行目**: MyExport()関数を呼び出し
6. **11行目**: 戻り値をコンソール出力

#### Step 3: C#ライブラリを理解する

エクスポートされるC#クラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LibraryMode.cs | `src/mono/wasm/testassets/LibraryMode/LibraryMode.cs` | partialクラスとJSExport属性の使用 |

**主要処理フロー**:
- **9行目**: partialクラス定義（JSInterop用）
- **11行目**: `[JSExport]`属性でJavaScriptから呼び出し可能に
- **12-16行目**: MyExport()メソッドの実装、戻り値100

#### Step 4: プロジェクト設定を理解する

ライブラリモードの設定を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | LibraryMode.csproj | `src/mono/wasm/testassets/LibraryMode/LibraryMode.csproj` | OutputTypeがLibraryに設定されている点が重要 |

**主要処理フロー**:
- **6行目**: `<OutputType>Library</OutputType>`でライブラリモードを指定

### プログラム呼び出し階層図

```
main.js (エントリーポイント)
    │
    ├─ dotnet.create() ─────────────────────┐
    │      └─ WebAssemblyランタイム初期化    │
    │                                        │
    ├─ getConfig()                           │  ※ runMain()は
    │      └─ 設定情報取得                   │    呼び出さない
    │                                        │
    ├─ getAssemblyExports(mainAssemblyName) ─┘
    │      └─ C#エクスポート関数を取得
    │
    └─ exports.LibraryMode.Test.MyExport()
           │
           └─ LibraryMode.Test.MyExport() [C#]
                  │
                  ├─ Console.WriteLine("TestOutput -> ...")
                  │
                  └─ return 100
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ページロード             JavaScript                     コンソール
(自動実行)    ───▶    main.js                   ───▶    console.log
                          │
                          ▼
                    dotnet.create()
                    (ライブラリモード初期化)
                          │
                          ▼
                    getAssemblyExports()
                          │
                          ▼
                    MyExport() [C#]
                          │
                          ▼
                    return 100
                          │
                          ▼
                    "WASM EXIT 100"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/mono/wasm/testassets/LibraryMode/wwwroot/index.html` | テンプレート | 最小限のHTML構造（UIなし） |
| main.js | `src/mono/wasm/testassets/LibraryMode/wwwroot/main.js` | ソース | JavaScriptエントリーポイント |
| LibraryMode.cs | `src/mono/wasm/testassets/LibraryMode/LibraryMode.cs` | ソース | JSExportメソッドを定義するC#クラス |
| LibraryMode.csproj | `src/mono/wasm/testassets/LibraryMode/LibraryMode.csproj` | 設定 | ライブラリモード設定（OutputType=Library） |
| AssemblyInfo.cs | `src/mono/wasm/testassets/LibraryMode/Properties/AssemblyInfo.cs` | ソース | アセンブリ属性定義 |
