# 画面設計書 14-WasmBrowserRunMainOnly

## 概要

本ドキュメントは、Wasm Main関数実行専用のテスト画面の設計書です。この画面は、WebAssemblyでMain関数のみを実行し、実行完了後に即座に終了するシンプルな実行モデルをテストするためのアセットです。

### 本画面の処理概要

この画面では、.NET WebAssemblyのrunMainAndExit()関数を使用して、C#のMain関数を実行し、完了後にプロセスを終了します。ランタイムを常駐させる必要がない一回限りの処理を行うWebAssemblyアプリケーションのパターンを検証します。

**業務上の目的・背景**：本画面は、WebAssemblyの「実行して終了」パターンをテストするためのアセットです。通常のWebAssemblyアプリケーションはランタイムを常駐させてユーザーインタラクションを処理しますが、バッチ処理やコマンドライン風のツールでは、Main関数を実行して完了したら即座に終了するパターンが必要になります。runMainAndExit()はこのユースケースに対応しています。

**画面へのアクセス方法**：ブラウザでアプリケーションのルートURL（index.html）に直接アクセスすることで画面が表示されます。画面には視覚的なUIは表示されず、処理結果はコンソールに出力されます。

**主要な操作・処理内容**：
1. dotnetモジュールをインポート
2. dotnet.runMainAndExit()でMain関数を実行
3. Main関数内で"Hello from WasmBrowserRunMainOnly!"を出力
4. 戻り値0でプロセス終了

**画面遷移**：この画面は単一画面テストアプリケーションのため、他画面への遷移はありません。

**権限による表示制御**：認証・権限機能は実装されていません。テスト用アセットのため、すべての機能が実行可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | WebAssemblyランタイム上でMain関数のみを実行 |
| 59 | WebAssembly Workload | 主機能 | WebAssemblyアプリケーションのビルドと実行をサポート |
| 40 | WasmAppBuilder | 補助機能 | WebAssemblyアプリケーションのビルドサポート |

## 画面種別

テスト実行画面（Main関数実行テスト）

## URL/ルーティング

- パス: `/index.html`
- テンプレートファイル: `src/mono/wasm/testassets/WasmBrowserRunMainOnly/wwwroot/index.html`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 |
|--------|----------|-----|------|
| なし | - | - | 画面にUI要素はなし |

## 表示項目

| 項目名 | 説明 | 初期値 |
|--------|------|--------|
| なし | 画面にはbody要素のみ、表示項目なし | - |

## イベント仕様

### 1-ページロード時のMain関数実行

**トリガー**: ページロード完了後、main.jsモジュールが実行される

**処理フロー**:
1. dotnetモジュールをインポート
2. dotnet.runMainAndExit()を呼び出し
3. C#のMain関数が実行される
4. "Hello from WasmBrowserRunMainOnly!"をTestOutput経由で出力
5. Task.Delay(1)で非同期待機（テスト用）
6. return 0でMain関数終了
7. ランタイムが終了

**結果**: コンソールに "TestOutput -> Hello from WasmBrowserRunMainOnly!" が出力され、プロセスが終了する

## データベース更新仕様

本画面ではデータベース操作は行いません。

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|---------------|---------|---------------|
| コンソール出力 | Main関数実行時 | "TestOutput -> Hello from WasmBrowserRunMainOnly!" |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| ランタイム初期化失敗 | ブラウザのデフォルトエラー表示 |
| Main関数内で例外発生 | 非0の終了コードでプロセス終了 |

## 備考

- 本画面はWebAssemblyのrunMainAndExit()機能のテスト用アセットです
- Main関数完了後にランタイムが終了するため、後続のJavaScript呼び出しは不可能です
- 非同期Main関数（async Task<int> Main）をサポートしています
- フィンガープリント機能（`main#[.{fingerprint}].js`）によりブラウザキャッシュの制御が行われます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Main関数の戻り値と終了コードの関係を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/mono/wasm/testassets/WasmBrowserRunMainOnly/Program.cs` | async Task<int>型のMain関数の定義 |

**読解のコツ**: Main関数の戻り値がプロセスの終了コードになります。0は正常終了を意味します。

#### Step 2: エントリーポイントを理解する

JavaScriptエントリーポイントの処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.js | `src/mono/wasm/testassets/WasmBrowserRunMainOnly/wwwroot/main.js` | runMainAndExit()の使用法。create()やrunMain()との違いを理解する |

**主要処理フロー**:
1. **4行目**: dotnetモジュールをインポート
2. **6行目**: dotnet.runMainAndExit()でMain関数を実行し、完了後終了

#### Step 3: C#のMain関数を理解する

Main関数の実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Program.cs | `src/mono/wasm/testassets/WasmBrowserRunMainOnly/Program.cs` | 非同期Main関数のシンプルな実装 |

**主要処理フロー**:
- **8行目**: `static async Task<int> Main(string[] args)`で非同期エントリーポイントを定義
- **10行目**: TestOutput.WriteLine()でメッセージ出力
- **11行目**: Task.Delay(1)で非同期待機
- **12行目**: return 0で正常終了

#### Step 4: テスト出力ヘルパーを理解する

TestOutputクラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | TestOutput.cs | `src/mono/wasm/testassets/WasmBrowserRunMainOnly/TestOutput.cs` | テスト結果出力用のヘルパークラス |

### プログラム呼び出し階層図

```
main.js (エントリーポイント)
    │
    └─ dotnet.runMainAndExit()
           │
           ├─ WebAssemblyランタイム初期化
           │
           ├─ Program.Main() [C#]
           │      │
           │      ├─ TestOutput.WriteLine("Hello from ...")
           │      │      └─ Console.WriteLine("TestOutput -> ...")
           │      │
           │      ├─ await Task.Delay(1)
           │      │
           │      └─ return 0
           │
           └─ ランタイム終了（終了コード0）
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ページロード             JavaScript                     コンソール
(自動実行)    ───▶    main.js                   ───▶    console.log
                          │
                          ▼
                  runMainAndExit()
                          │
                          ▼
                  Program.Main() [C#]
                          │
                          ▼
               TestOutput.WriteLine()
                          │
                          ▼
                  return 0
                          │
                          ▼
                  プロセス終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/mono/wasm/testassets/WasmBrowserRunMainOnly/wwwroot/index.html` | テンプレート | 最小限のHTML構造（UIなし） |
| main.js | `src/mono/wasm/testassets/WasmBrowserRunMainOnly/wwwroot/main.js` | ソース | JavaScriptエントリーポイント |
| Program.cs | `src/mono/wasm/testassets/WasmBrowserRunMainOnly/Program.cs` | ソース | C#のMain関数を定義 |
| TestOutput.cs | `src/mono/wasm/testassets/WasmBrowserRunMainOnly/TestOutput.cs` | ソース | テスト出力用ヘルパークラス |
| WasmBrowserRunMainOnly.csproj | `src/mono/wasm/testassets/WasmBrowserRunMainOnly/WasmBrowserRunMainOnly.csproj` | 設定 | プロジェクト設定 |
| AssemblyInfo.cs | `src/mono/wasm/testassets/WasmBrowserRunMainOnly/Properties/AssemblyInfo.cs` | ソース | アセンブリ属性定義 |
