# 画面設計書 16-BlazorBasicTestApp

## 概要

本ドキュメントは、Blazor WebAssemblyの基本テストアプリのエントリーポイント画面の設計書です。この画面は、Blazor WebAssemblyフレームワークの基本機能をテストするためのアセットとして機能し、SPAアプリケーションのルートHTMLを提供します。

### 本画面の処理概要

この画面では、Blazor WebAssemblyアプリケーションの起動に必要なHTMLシェルを提供します。ブラウザがこのHTMLを読み込むと、Blazor WebAssemblyランタイムが初期化され、Razorコンポーネントがレンダリングされます。ローディング表示、エラーUI、スタイルシート参照などの標準的なBlazor構成要素が含まれています。

**業務上の目的・背景**：本画面は、Blazor WebAssemblyの基本機能をテストするためのアセットです。SPAフレームワークとしてのBlazorの動作検証に使用され、コンポーネントレンダリング、ルーティング、イベント処理などの基本機能が正常に動作することを確認します。また、CI/CDパイプラインでのBlazor WebAssemblyビルドとランタイムの品質保証にも活用されます。

**画面へのアクセス方法**：ブラウザでアプリケーションのルートURL（/）にアクセスすることで画面が表示されます。base hrefが"/"に設定されているため、すべてのルーティングはこのパスを基準に解決されます。

**主要な操作・処理内容**：
1. index.htmlがブラウザに読み込まれる
2. ローディングプログレスが表示される
3. blazor.webassembly.jsが読み込まれる
4. WebAssemblyランタイムが初期化される
5. Appコンポーネントが#app要素にマウントされる
6. ルーターが現在のURLに応じたページを表示

**画面遷移**：BlazorBasicTestApp内で以下の画面に遷移可能です。
- Home（/）：ホームページ
- Counter（/counter）：カウンターページ
- Weather（/weather）：天気ページ（ナビゲーションメニューに存在）

**権限による表示制御**：認証・権限機能は実装されていません。テスト用アセットのため、すべてのページにアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | Blazor WebAssemblyランタイム上でテストアプリを実行 |
| 59 | WebAssembly Workload | 主機能 | Blazor WebAssemblyアプリケーションのビルドと実行をサポート |
| 31 | Microsoft.Extensions.DependencyInjection | 補助機能 | Blazorの依存性注入コンテナ |

## 画面種別

エントリーポイント画面（Blazor WebAssembly SPA）

## URL/ルーティング

- パス: `/index.html` または `/`
- テンプレートファイル: `src/mono/wasm/testassets/BlazorBasicTestApp/App/wwwroot/index.html`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 |
|--------|----------|-----|------|
| なし | - | - | エントリーポイントのため直接の入出力項目はなし |

## 表示項目

| 項目名 | 説明 | 初期値 |
|--------|------|--------|
| ローディングプログレス | アプリ読み込み中に表示されるSVG円形プログレス | 表示中 |
| エラーUI | 未処理例外発生時に表示されるエラーパネル | 非表示 |
| アプリケーションルート | Blazorコンポーネントがマウントされるdiv#app | - |

## イベント仕様

### 1-ページロード時のBlazorアプリ初期化

**トリガー**: ブラウザがindex.htmlを読み込み完了

**処理フロー**:
1. CSSファイル（bootstrap.min.css, app.css, styles.css）が読み込まれる
2. div#appにローディングプログレスが表示される
3. blazor.webassembly.jsスクリプトが実行される
4. WebAssemblyランタイムが初期化される
5. Program.csのMainメソッドが実行される
6. WebAssemblyHostBuilderでアプリケーションが構成される
7. Appコンポーネントが#appにマウントされる
8. ルーターが現在のURLを解析してページコンポーネントをレンダリング

**結果**: Blazorアプリケーションが表示され、ユーザー操作が可能になる

### 2-エラー発生時

**トリガー**: Blazorアプリケーション内で未処理例外が発生

**処理フロー**:
1. エラーUI（div#blazor-error-ui）が表示される
2. ユーザーはReloadリンクでページ再読み込み可能
3. dismissボタンでエラーUIを閉じることも可能

**結果**: エラー情報がユーザーに表示される

## データベース更新仕様

本画面ではデータベース操作は行いません。

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|---------------|---------|---------------|
| エラーUI | 未処理例外発生時 | "An unhandled error has occurred." |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| WebAssembly読み込み失敗 | ローディングプログレスが表示されたまま |
| 未処理例外 | blazor-error-uiが表示される |

## 備考

- 本画面はBlazor WebAssemblyテストアプリケーションのエントリーポイントです
- Bootstrapスタイルが適用されています
- フィンガープリント機能によりブラウザキャッシュが制御されます
- HeadOutletコンポーネントによりhead要素の動的更新が可能です

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Blazorアプリケーションの起動構成を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Program.cs` | WebAssemblyHostBuilderの構成とルートコンポーネントの登録 |

**読解のコツ**: WebAssemblyHostBuilder.CreateDefault()からRunAsync()までの流れがBlazorアプリの起動シーケンスです。

#### Step 2: エントリーポイントを理解する

HTMLシェルの構成を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `src/mono/wasm/testassets/BlazorBasicTestApp/App/wwwroot/index.html` | 標準的なBlazor WebAssemblyのHTML構造 |

**主要処理フロー**:
1. **8行目**: base href="/"でルーティングのベースパスを設定
2. **9-12行目**: スタイルシートの読み込み（Bootstrap, app.css, styles.css）
3. **17-22行目**: ローディングプログレスのSVG表示
4. **25-28行目**: エラーUI（非表示状態）
5. **30行目**: blazor.webassembly.jsの読み込み

#### Step 3: ルートコンポーネントを理解する

Appコンポーネントとルーティングを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | App.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/App.razor` | Routerコンポーネントの構成 |
| 3-2 | MainLayout.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/MainLayout.razor` | レイアウトコンポーネント |
| 3-3 | NavMenu.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/NavMenu.razor` | ナビゲーションメニュー |

**主要処理フロー**:
- **App.razor 1-12行目**: Routerコンポーネントでルーティングを設定、Found/NotFoundのハンドリング
- **MainLayout.razor 1-16行目**: サイドバー + メインコンテンツ構造
- **NavMenu.razor 12-26行目**: Home, Counter, Weatherへのナビゲーションリンク

#### Step 4: C#起動コードを理解する

Program.csの構成を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Program.cs | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Program.cs` | DIコンテナとルートコンポーネントの構成 |

**主要処理フロー**:
- **5行目**: WebAssemblyHostBuilder.CreateDefault()でビルダー作成
- **6行目**: App コンポーネントを#appにマウント
- **7行目**: HeadOutletをhead::afterにマウント
- **9行目**: HttpClientをスコープサービスとして登録
- **11行目**: RunAsync()でアプリケーション起動

### プログラム呼び出し階層図

```
index.html (HTMLシェル)
    │
    ├─ CSS読み込み
    │      ├─ bootstrap.min.css
    │      ├─ app.css
    │      └─ BlazorBasicTestApp.styles.css
    │
    ├─ div#app (Blazorマウントポイント)
    │      └─ ローディングプログレス表示
    │
    └─ blazor.webassembly.js
           │
           └─ Program.Main() [C#]
                  │
                  ├─ WebAssemblyHostBuilder.CreateDefault()
                  │
                  ├─ RootComponents.Add<App>("#app")
                  │
                  ├─ RootComponents.Add<HeadOutlet>("head::after")
                  │
                  ├─ Services.AddScoped<HttpClient>()
                  │
                  └─ builder.Build().RunAsync()
                         │
                         └─ App.razor
                                │
                                ├─ Router (ルーティング)
                                │      ├─ Found → RouteView → ページコンポーネント
                                │      └─ NotFound → "Sorry, there's nothing at this address."
                                │
                                └─ MainLayout.razor
                                       ├─ NavMenu.razor (サイドバー)
                                       └─ @Body (ページコンテンツ)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ブラウザリクエスト        HTMLシェル                    Blazor SPA
/               ───▶    index.html               ───▶    App.razor
                              │
                              ▼
                    blazor.webassembly.js
                              │
                              ▼
                    Program.Main() [C#]
                              │
                              ▼
                    Router → RouteView
                              │
                              ▼
                    ページコンポーネント
                    (Home/Counter/Weather)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/mono/wasm/testassets/BlazorBasicTestApp/App/wwwroot/index.html` | テンプレート | Blazor WebAssemblyのHTMLシェル |
| Program.cs | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Program.cs` | ソース | アプリケーション起動とDI構成 |
| App.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/App.razor` | ソース | ルートコンポーネント、ルーティング設定 |
| MainLayout.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/MainLayout.razor` | ソース | レイアウトコンポーネント |
| NavMenu.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/NavMenu.razor` | ソース | ナビゲーションメニュー |
| _Imports.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/_Imports.razor` | ソース | グローバルusing宣言 |
| Home.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Home.razor` | ソース | ホームページ（/） |
| Counter.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Counter.razor` | ソース | カウンターページ（/counter） |
| BlazorBasicTestApp.csproj | `src/mono/wasm/testassets/BlazorBasicTestApp/App/BlazorBasicTestApp.csproj` | 設定 | プロジェクト設定 |
