# 画面設計書 18-Home（BlazorBasicTestApp）

## 概要

本ドキュメントは、BlazorBasicTestAppのホームページの設計書です。この画面は、Blazor WebAssemblyアプリケーションのルートページとして機能し、"Hello, world!"メッセージを表示するシンプルな画面です。

### 本画面の処理概要

この画面では、Blazor WebAssemblyアプリケーションのホームページとして、基本的なコンポーネントレンダリングを行います。PageTitle、見出し、ウェルカムメッセージを表示し、初回レンダリング完了時にテスト出力としてコンソールにメッセージを出力します。

**業務上の目的・背景**：本画面は、Blazor WebAssemblyの基本的なページコンポーネントのテストを目的としています。コンポーネントのライフサイクル（OnAfterRender）の動作確認、PageTitleコンポーネントによるブラウザタイトルの設定、基本的なHTMLレンダリングの検証に使用されます。テスト完了を示す"WASM EXIT 0"を出力することで、自動テストでの正常終了判定に活用されます。

**画面へのアクセス方法**：ブラウザでアプリケーションのルートURL（/）にアクセスするか、ナビゲーションメニューから「Home」を選択することで表示されます。

**主要な操作・処理内容**：
1. ルーターが/パスを解析してHome.razorをレンダリング
2. PageTitleコンポーネントでブラウザタイトルを"Home"に設定
3. h1見出しで"Hello, world!"を表示
4. ウェルカムメッセージを表示
5. 初回レンダリング完了時に"WASM EXIT 0"をコンソール出力

**画面遷移**：BlazorBasicTestApp内で以下の画面に遷移可能です。
- Counter（/counter）：ナビゲーションメニューから
- Weather（/weather）：ナビゲーションメニューから

**権限による表示制御**：認証・権限機能は実装されていません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | Blazor WebAssemblyランタイム上でホームページを表示 |
| 59 | WebAssembly Workload | 主機能 | Blazor WebAssemblyアプリケーションのビルドと実行をサポート |

## 画面種別

トップページ（ホームページ）

## URL/ルーティング

- パス: `/`
- Razorファイル: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Home.razor`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 |
|--------|----------|-----|------|
| なし | - | - | 静的表示のため入出力項目なし |

## 表示項目

| 項目名 | 説明 | 値 |
|--------|------|-----|
| ブラウザタイトル | PageTitleで設定されるタブタイトル | Home |
| 見出し | h1要素で表示されるメインタイトル | Hello, world! |
| ウェルカムメッセージ | 本文テキスト | Welcome to your new app. |

## イベント仕様

### 1-初回レンダリング完了時

**トリガー**: コンポーネントの初回レンダリングが完了（OnAfterRender, firstRender=true）

**処理フロー**:
1. OnAfterRender(bool firstRender)が呼び出される
2. firstRenderがtrueの場合のみ処理を実行
3. Console.WriteLine("WASM EXIT 0")を出力

**結果**: コンソールに"WASM EXIT 0"が出力され、テスト成功を示す

## データベース更新仕様

本画面ではデータベース操作は行いません。

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|---------------|---------|---------------|
| コンソール出力 | 初回レンダリング完了時 | "WASM EXIT 0" |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| レンダリング例外 | Blazorのエラーハンドリングに委譲 |

## 備考

- 本画面はBlazor WebAssemblyテストアプリケーションのホームページです
- "WASM EXIT 0"出力はテスト完了の成功判定に使用されます
- 静的なコンテンツのみで、ユーザーインタラクションはありません

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

シンプルなページコンポーネントのため、複雑なデータ構造はありません。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Home.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Home.razor` | Razorコンポーネントの基本構造 |

**読解のコツ**: @page ディレクティブでルーティングを定義し、@code ブロックでC#コードを記述します。

#### Step 2: エントリーポイントを理解する

ページコンポーネントの構成を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Home.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Home.razor` | @page "/"でルートにマッピング |

**主要処理フロー**:
1. **1行目**: `@page "/"`でルートURLにマッピング
2. **3行目**: `<PageTitle>Home</PageTitle>`でブラウザタイトル設定
3. **5行目**: `<h1>Hello, world!</h1>`で見出し表示
4. **7行目**: ウェルカムメッセージ表示
5. **9-16行目**: @codeブロックでOnAfterRenderをオーバーライド

#### Step 3: ライフサイクルメソッドを理解する

OnAfterRenderの動作を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Home.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Home.razor` | OnAfterRenderでテスト出力 |

**主要処理フロー**:
- **10行目**: `protected override void OnAfterRender(bool firstRender)`
- **12-15行目**: firstRenderがtrueの場合に"WASM EXIT 0"を出力

### プログラム呼び出し階層図

```
Router (App.razor)
    │
    └─ RouteView
           │
           └─ Home.razor (@page "/")
                  │
                  ├─ BuildRenderTree()
                  │      ├─ PageTitle → "Home"
                  │      ├─ h1 → "Hello, world!"
                  │      └─ テキスト → "Welcome to your new app."
                  │
                  └─ OnAfterRender(firstRender=true)
                         │
                         └─ Console.WriteLine("WASM EXIT 0")
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ルートURL (/)           Blazor Router                    DOM
                  ───▶  Home.razor                 ───▶  h1, p要素
                              │
                              ▼
                    OnAfterRender(firstRender)
                              │
                              ▼
                    Console.WriteLine
                              │
                              ▼
                    "WASM EXIT 0"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Home.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Home.razor` | ソース | ホームページコンポーネント |
| App.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/App.razor` | ソース | ルーティング設定 |
| MainLayout.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/MainLayout.razor` | ソース | レイアウトコンポーネント |
| NavMenu.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/NavMenu.razor` | ソース | ナビゲーションメニュー（Homeへのリンク含む） |
