# 画面設計書 19-Counter（BlazorBasicTestApp）

## 概要

本ドキュメントは、BlazorBasicTestAppのカウンターページの設計書です。この画面は、Blazor WebAssemblyアプリケーションにおけるインタラクティブなコンポーネントのテストを目的とし、ボタンクリックでカウントが増加する機能を提供します。

### 本画面の処理概要

この画面では、Blazor WebAssemblyアプリケーションにおけるイベントハンドリングと状態管理の基本パターンを実装しています。「Click me」ボタンをクリックするたびにカウンターが1ずつ増加し、現在のカウント値がリアルタイムで画面に表示されます。

**業務上の目的・背景**：本画面は、Blazorコンポーネントのイベントハンドリングと状態管理のテストを目的としています。@onclickディレクティブによるボタンクリックイベントの処理、プライベートフィールドによる状態保持、UIの自動再レンダリングの動作を検証します。Blazor WebAssemblyアプリケーション開発の基本パターンを示すサンプルとして機能します。

**画面へのアクセス方法**：ブラウザで`/counter`パスにアクセスするか、ナビゲーションメニューから「Counter」を選択することで表示されます。

**主要な操作・処理内容**：
1. ルーターが/counterパスを解析してCounter.razorをレンダリング
2. PageTitleコンポーネントでブラウザタイトルを"Counter"に設定
3. h1見出しで"Counter"を表示
4. 現在のカウント値（初期値0）を表示
5. 「Click me」ボタンをクリックするとカウントが増加
6. UIが自動的に再レンダリングされ新しい値を表示

**画面遷移**：BlazorBasicTestApp内で以下の画面に遷移可能です。
- Home（/）：ナビゲーションメニューから
- Weather（/weather）：ナビゲーションメニューから

**権限による表示制御**：認証・権限機能は実装されていません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | Blazor WebAssemblyランタイム上でカウンター機能を実行 |
| 59 | WebAssembly Workload | 主機能 | Blazor WebAssemblyアプリケーションのビルドと実行をサポート |

## 画面種別

機能画面（インタラクティブカウンター）

## URL/ルーティング

- パス: `/counter`
- Razorファイル: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Counter.razor`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 |
|--------|----------|-----|------|
| Click meボタン | 入力 | イベント | カウント増加トリガー |
| currentCount | 出力 | int | 現在のカウント値 |

## 表示項目

| 項目名 | 説明 | 初期値 |
|--------|------|--------|
| ブラウザタイトル | PageTitleで設定されるタブタイトル | Counter |
| 見出し | h1要素で表示されるタイトル | Counter |
| カウント表示 | 現在のカウント値を表示するp要素 | Current count: 0 |
| カウントボタン | カウント増加ボタン | Click me |

## イベント仕様

### 1-Click meボタンクリック

**トリガー**: 「Click me」ボタンをクリック

**処理フロー**:
1. @onclickディレクティブによりIncrementCount()メソッドが呼び出される
2. currentCountプライベートフィールドを1増加（currentCount++）
3. Blazorの変更検知により自動的に再レンダリングがトリガーされる
4. カウント表示が更新される

**結果**: カウント値が1増加し、画面表示が更新される

## データベース更新仕様

本画面ではデータベース操作は行いません。カウント値はコンポーネントのプライベートフィールドに保持され、ページをリロードするとリセットされます。

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|---------------|---------|---------------|
| なし | - | メッセージ表示機能なし |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| レンダリング例外 | Blazorのエラーハンドリングに委譲 |

## 備考

- 本画面はBlazor WebAssemblyテストアプリケーションのカウンターページです
- 状態はコンポーネントインスタンスに保持され、ページリロードでリセットされます
- btn-primaryクラスでBootstrapスタイルが適用されています
- role="status"属性でアクセシビリティに配慮しています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カウンター状態を保持するフィールドの構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Counter.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Counter.razor` | privateフィールドcurrentCountの定義と初期値 |

**読解のコツ**: Blazorコンポーネントでは、@codeブロック内のフィールドがコンポーネントの状態を保持します。

#### Step 2: UIテンプレートを理解する

Razorマークアップの構成を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Counter.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Counter.razor` | データバインディング（@currentCount）とイベントハンドリング（@onclick） |

**主要処理フロー**:
1. **1行目**: `@page "/counter"`でルーティング設定
2. **3行目**: `<PageTitle>Counter</PageTitle>`でブラウザタイトル設定
3. **5行目**: `<h1>Counter</h1>`で見出し表示
4. **7行目**: `<p role="status">Current count: @currentCount</p>`でカウント表示
5. **9行目**: `<button class="btn btn-primary" @onclick="IncrementCount">Click me</button>`でボタン配置

#### Step 3: イベントハンドラを理解する

IncrementCountメソッドの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Counter.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Counter.razor` | @codeブロック内のイベントハンドラ |

**主要処理フロー**:
- **12行目**: `private int currentCount = 0;`でカウンターを初期化
- **14-17行目**: `private void IncrementCount() { currentCount++; }`でカウント増加処理

### プログラム呼び出し階層図

```
Router (App.razor)
    │
    └─ RouteView
           │
           └─ Counter.razor (@page "/counter")
                  │
                  ├─ BuildRenderTree()
                  │      ├─ PageTitle → "Counter"
                  │      ├─ h1 → "Counter"
                  │      ├─ p → "Current count: {currentCount}"
                  │      └─ button → "Click me" + @onclick
                  │
                  └─ [ボタンクリック時]
                         │
                         └─ IncrementCount()
                                │
                                ├─ currentCount++
                                │
                                └─ StateHasChanged() [自動呼び出し]
                                       │
                                       └─ 再レンダリング
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ボタンクリック           Blazorイベント                  DOM更新
Click me     ───▶    @onclick                    ───▶    p要素
                          │
                          ▼
                    IncrementCount()
                          │
                          ▼
                    currentCount++
                          │
                          ▼
                    StateHasChanged (自動)
                          │
                          ▼
                    再レンダリング
                          │
                          ▼
                    "Current count: {N}"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Counter.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Counter.razor` | ソース | カウンターページコンポーネント |
| App.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/App.razor` | ソース | ルーティング設定 |
| MainLayout.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/MainLayout.razor` | ソース | レイアウトコンポーネント |
| NavMenu.razor | `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/NavMenu.razor` | ソース | ナビゲーションメニュー（Counterへのリンク含む） |
