# 画面設計書 20-Home（BlazorWebWasm）

## 概要

本ドキュメントは、BlazorWebWasmアプリケーションのホームページの設計書です。この画面は、ASP.NET CoreサーバーとBlazor WebAssemblyクライアントが統合された環境でのホームページを提供します。

### 本画面の処理概要

この画面では、BlazorWebWasmアプリケーションのホームページとして、"Hello, world!"メッセージを表示するシンプルな画面を提供します。BlazorBasicTestAppのHomeページとは異なり、このアプリケーションはASP.NET Coreサーバーと統合されており、InteractiveWebAssemblyRenderModeを使用するハイブリッドアーキテクチャで動作します。

**業務上の目的・背景**：本画面は、Blazor WebAssemblyとASP.NET Coreの統合アーキテクチャのテストを目的としています。サーバーサイドレンダリング（SSR）とクライアントサイドのWebAssemblyを組み合わせた.NET 8以降の新しいBlazor統合モデルの動作検証に使用されます。UseStatusCodePagesWithReExecuteによる404ページへのリダイレクト、リクエストログ機能などのサーバー機能との統合もテストします。

**画面へのアクセス方法**：ブラウザでアプリケーションのルートURL（/）にアクセスするか、ナビゲーションメニューから「Home」を選択することで表示されます。

**主要な操作・処理内容**：
1. ASP.NET Coreサーバーがリクエストを受信
2. Appコンポーネントがサーバーサイドでレンダリング
3. ルーターがHome.razorを選択
4. PageTitleでブラウザタイトルを"Home"に設定
5. "Hello, world!"とウェルカムメッセージを表示

**画面遷移**：BlazorWebWasm内で以下の画面に遷移可能です。
- Counter（/counter）：ナビゲーションメニューから（InteractiveWebAssemblyモード）
- Weather（/weather）：ナビゲーションメニューから
- Error（/Error）：エラー発生時
- Not Found（/not-found）：存在しないURLアクセス時

**権限による表示制御**：認証・権限機能は実装されていません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | Blazor WebAssemblyランタイム上でホームページを表示 |
| 59 | WebAssembly Workload | 主機能 | Blazor WebAssemblyアプリケーションのビルドと実行をサポート |

## 画面種別

トップページ（ホームページ）

## URL/ルーティング

- パス: `/`
- Razorファイル: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/Home.razor`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 |
|--------|----------|-----|------|
| なし | - | - | 静的表示のため入出力項目なし |

## 表示項目

| 項目名 | 説明 | 値 |
|--------|------|-----|
| ブラウザタイトル | PageTitleで設定されるタブタイトル | Home |
| 見出し | h1要素で表示されるメインタイトル | Hello, world! |
| ウェルカムメッセージ | 本文テキスト | Welcome to your new app. |

## イベント仕様

### 1-ページロード時

**トリガー**: ブラウザがルートURLにアクセス

**処理フロー**:
1. ASP.NET Coreサーバーがリクエストを受信
2. UseAntiforgery()でCSRF対策を適用
3. MapRazorComponents<App>()でBlazorコンポーネントをマッピング
4. Appコンポーネントがレンダリング
5. Routerが/パスを解析してHome.razorを選択
6. Home.razorがレンダリングされる

**結果**: ホームページが表示される

## データベース更新仕様

本画面ではデータベース操作は行いません。

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|---------------|---------|---------------|
| なし | - | メッセージ表示機能なし |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| レンダリング例外 | /Errorページにリダイレクト |
| 404エラー | /not-foundページにリダイレクト（UseStatusCodePagesWithReExecute） |

## 備考

- 本画面はBlazorWebWasmテストアプリケーションのホームページです
- ASP.NET Coreサーバーと統合されたBlazorアプリケーションです
- サーバーサイドでのリクエストログ機能が有効化されています
- BlazorBasicTestAppのHomeと異なり、OnAfterRenderでのテスト出力はありません

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サーバー構成を理解する

ASP.NET Coreサーバーの構成を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Program.cs` | AddRazorComponents()とAddInteractiveWebAssemblyComponents()の設定 |

**読解のコツ**: .NET 8以降のBlazor統合モデルでは、サーバーサイドでコンポーネントをホストしつつ、必要に応じてWebAssemblyでインタラクティブにできます。

#### Step 2: ページコンポーネントを理解する

Home.razorの構成を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Home.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/Home.razor` | 非常にシンプルな静的コンテンツ |

**主要処理フロー**:
1. **1行目**: `@page "/"`でルートURLにマッピング
2. **3行目**: `<PageTitle>Home</PageTitle>`でブラウザタイトル設定
3. **5行目**: `<h1>Hello, world!</h1>`で見出し表示
4. **7行目**: ウェルカムメッセージ表示

#### Step 3: レイアウトを理解する

レイアウトとナビゲーションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MainLayout.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Layout/MainLayout.razor` | サイドバー+メインコンテンツ構造 |
| 3-2 | NavMenu.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Layout/NavMenu.razor` | ナビゲーションリンク |

**主要処理フロー**:
- **MainLayout.razor**: サイドバーにNavMenu、メインにBody（ページコンテンツ）
- **NavMenu.razor**: Home, Counter, Weatherへのリンク

#### Step 4: サーバー側処理を理解する

Program.csのミドルウェア設定を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Program.cs | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Program.cs` | リクエストログ、ステータスコードページ設定 |

**主要処理フロー**:
- **8-9行目**: AddRazorComponents()とAddInteractiveWebAssemblyComponents()
- **16-29行目**: リクエストログミドルウェア
- **42行目**: UseStatusCodePagesWithReExecute("/not-found")で404処理
- **48-50行目**: MapRazorComponents + AddInteractiveWebAssemblyRenderMode

### プログラム呼び出し階層図

```
ASP.NET Core Server
    │
    ├─ Program.cs
    │      ├─ AddRazorComponents()
    │      ├─ AddInteractiveWebAssemblyComponents()
    │      ├─ リクエストログミドルウェア
    │      ├─ UseStatusCodePagesWithReExecute("/not-found")
    │      ├─ UseAntiforgery()
    │      └─ MapRazorComponents<App>()
    │
    └─ HTTP Request (/)
           │
           └─ App.razor
                  │
                  └─ Routes.razor
                         │
                         └─ Router
                                │
                                └─ RouteView
                                       │
                                       └─ MainLayout.razor
                                              │
                                              ├─ NavMenu.razor (サイドバー)
                                              │
                                              └─ Home.razor (@page "/")
                                                     │
                                                     ├─ PageTitle → "Home"
                                                     ├─ h1 → "Hello, world!"
                                                     └─ "Welcome to your new app."
```

### データフロー図

```
[入力]                      [処理]                           [出力]

HTTPリクエスト          ASP.NET Core                    HTML/Blazor
GET /        ───▶    Server                      ───▶    Home.razor
                          │
                          ▼
                    リクエストログ記録
                          │
                          ▼
                    MapRazorComponents
                          │
                          ▼
                    App → Routes → Router
                          │
                          ▼
                    Home.razor
                          │
                          ▼
                    HTMLレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Home.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/Home.razor` | ソース | ホームページコンポーネント |
| Program.cs | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Program.cs` | ソース | サーバー構成とミドルウェア設定 |
| App.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/App.razor` | ソース | ルートコンポーネント |
| Routes.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Routes.razor` | ソース | ルーティング設定 |
| MainLayout.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Layout/MainLayout.razor` | ソース | レイアウトコンポーネント |
| NavMenu.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Layout/NavMenu.razor` | ソース | ナビゲーションメニュー |
| _Imports.razor | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/_Imports.razor` | ソース | グローバルusing宣言 |
| BlazorWebWasm.csproj | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/BlazorWebWasm.csproj` | 設定 | サーバープロジェクト設定 |
| BlazorWebWasm.Client.csproj | `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm.Client/BlazorWebWasm.Client.csproj` | 設定 | クライアントプロジェクト設定 |
