# 画面設計書 6-Profiler Sample

## 概要

本ドキュメントは、.NET WebAssembly のプロファイラーサンプル画面「Profiler Sample」の設計内容を記載した画面設計書です。本画面は .NET Runtime リポジトリにおける WebAssembly の AOT プロファイリング機能をデモンストレーションするサンプルアプリケーションです。

### 本画面の処理概要

本画面は、ブラウザ上で .NET WebAssembly ランタイムの AOT（Ahead-of-Time）プロファイリング機能を使用して、実行時のメソッド呼び出し情報を収集し、プロファイルデータファイル（.aotprofile）として保存するサンプルアプリケーションです。

**業務上の目的・背景**：本画面は、.NET WebAssembly アプリケーションの AOT プロファイリング機能を検証・デモンストレーションするために作成されました。AOT プロファイリングにより、実行時に呼び出されたメソッドの情報を収集し、次回のビルド時により効率的な AOT コンパイルを行うためのデータを生成できます。これにより、アプリケーションの起動時間短縮やメモリ使用量の最適化が可能になります。

**画面へのアクセス方法**：ローカル開発サーバー（通常は `http://localhost:8000/`）にブラウザでアクセスすることで画面を表示できます。

**主要な操作・処理内容**：
1. 画面ロード時に JavaScript（main.js）が .NET WebAssembly ランタイムを初期化
2. aotProfilerOptions でプロファイリングを設定
3. C# の `TestMeaning()` メソッドを呼び出し、結果（42）を取得
4. 結果を DOM に表示
5. `StopProfile()` でプロファイリングを停止
6. `saveProfile()` で AOT プロファイルデータをファイルとしてダウンロード

**画面遷移**：本画面は単一画面のサンプルアプリケーションであり、他画面への遷移はありません。

**権限による表示制御**：本画面は認証・認可機能を持たないデモアプリケーションであり、権限による表示制御はありません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | WebAssembly ランタイム上でプロファイリングを実行 |
| 59 | WebAssembly Workload | 主機能 | WebAssembly アプリケーションのビルドと実行をサポート |
| 49 | eventpipe | 補助機能 | プロファイリング用の診断イベントストリーミング |

## 画面種別

プロファイリングデモ画面（単一画面）

## URL/ルーティング

- ローカル開発: `http://localhost:8000/index.html`
- 静的ファイルパス: `src/mono/sample/wasm/browser-profile/wwwroot/index.html`

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| - | - | - | 本画面にユーザー入力項目はありません |

## 表示項目

| 項目ID | 項目名 | 要素タイプ | 説明 |
|--------|--------|-----------|------|
| header | 画面タイトル | h3 | 「Wasm Profiler Sample」と表示 |
| out | 計算結果 | span | Sample.Test.TestMeaning の結果（42）を表示 |

## イベント仕様

### 1-画面ロード完了イベント

画面がロードされると、以下の処理が自動的に実行されます:

1. `main.js` がモジュールとして読み込まれる
2. `dotnet.create()` で WebAssembly ランタイムを初期化
3. `aotProfilerOptions` でプロファイリングを設定
   - `writeAt`: "Sample.Test::StopProfile" - プロファイル書き込みトリガー
   - `sendTo`: AOT プロファイルデータの送信先メソッド
4. `getAssemblyExports` で C# の公開メソッドを取得
5. `testMeaning()` を呼び出し、結果を DOM に表示
6. `stopProfile()` を呼び出してプロファイリングを停止
7. `saveProfile(INTERNAL.aotProfileData)` でプロファイルデータをダウンロード
8. 結果が 42 の場合は終了コード 0、それ以外は 1 で終了

### 2-プロファイルデータ保存

1. `aotProfileData` から Blob を作成
2. a 要素を生成し `download` 属性に "data.aotprofile" を設定
3. クリックイベントを発火してダウンロードを開始
4. 一時的な a 要素を削除

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面はデータベースを使用しません |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | not ready yet | ランタイム初期化中 |
| MSG-002 | 情報 | ready | ランタイム初期化完了後 |
| MSG-003 | デバッグ | ret: {value} | testMeaning 結果取得後 |
| MSG-004 | 情報 | Hello, World! | C# Main メソッド実行時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| aotProfileData 未設定 | プロファイルデータが生成されなかった場合 | `throw new Error("aotProfileData not set")` |
| JavaScript エラー | ランタイム初期化失敗時 | `exit(-1, err)` で終了 |

## 備考

- `aotProfilerOptions.writeAt` でプロファイル書き込みのトリガーメソッドを指定
- `aotProfilerOptions.sendTo` で AOT プロファイルデータの送信先を指定
- プロファイルデータは `INTERNAL.aotProfileData` に格納される
- ダウンロードされるファイル名は "data.aotprofile"
- TestMeaning の期待結果は 42

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、AOT プロファイリングの設定とデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.js | `src/mono/sample/wasm/browser-profile/wwwroot/main.js` | aotProfilerOptions の設定を確認 |
| 1-2 | Program.cs | `src/mono/sample/wasm/browser-profile/Program.cs` | JSExport メソッドを確認 |

**読解のコツ**: `aotProfilerOptions` の `writeAt` と `sendTo` がプロファイリングの動作を決定します。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `src/mono/sample/wasm/browser-profile/wwwroot/index.html` | HTML 構造を確認 |
| 2-2 | main.js | `src/mono/sample/wasm/browser-profile/wwwroot/main.js` | プロファイリング処理フローを確認 |

**主要処理フロー (main.js)**:
1. **6-20行目**: `saveProfile` 関数 - AOT プロファイルデータをファイルとしてダウンロード
2. **21-31行目**: `dotnet.create()` でランタイム初期化（aotProfilerOptions 設定）
3. **33-36行目**: C# メソッドの取得と変数への格納
4. **38-39行目**: `testMeaning()` 呼び出しと DOM 更新
5. **42-43行目**: `stopProfile()` 呼び出しとプロファイルデータ保存
6. **45-46行目**: 結果に応じた終了コードで exit

#### Step 3: C# 側のプロファイリング対象を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Program.cs | `src/mono/sample/wasm/browser-profile/Program.cs` | TestMeaning と StopProfile の実装を確認 |

**主要処理フロー (Program.cs)**:
- **12-15行目**: `Main` - Hello, World! 出力
- **17-21行目**: `TestMeaning` - 42 を返すシンプルなメソッド
- **23-24行目**: `StopProfile` - プロファイリング停止トリガー（空実装）

### プログラム呼び出し階層図

```
[Browser] index.html 読み込み
    |
    +-- [JavaScript] main.js 実行
            |
            +-- dotnet.create() - WebAssembly ランタイム初期化
            |       |
            |       +-- aotProfilerOptions 設定
            |               |
            |               +-- writeAt: "Sample.Test::StopProfile"
            |               +-- sendTo: "...JavaScriptExports::DumpAotProfileData"
            |
            +-- getAssemblyExports() - C# メソッドを取得
            |
            +-- testMeaning() 呼び出し
            |       |
            |       +-- [C#] TestMeaning() 実行
            |               |
            |               +-- return 42
            |
            +-- DOM 更新 (#out に 42 を表示)
            |
            +-- stopProfile() 呼び出し
            |       |
            |       +-- [C#] StopProfile() 実行
            |               |
            |               +-- (プロファイリング停止トリガー)
            |               +-- AOT プロファイルデータが INTERNAL.aotProfileData に格納
            |
            +-- saveProfile(INTERNAL.aotProfileData)
                    |
                    +-- Blob 作成
                    +-- a 要素でダウンロード
                    +-- "data.aotprofile" として保存
```

### データフロー図

```
[入力]                      [処理]                           [出力]

                     +-- dotnet.create() ----+
                     |   aotProfilerOptions  |
                     +----------+-----------+
                                |
                                v
                     +-- TestMeaning() ----+
                     |   return 42         |
                     +----------+-----------+
                                |
                                v
                     document.getElementById("out")
                        .innerHTML = "42"
                              |
                              v
                     +-- StopProfile() ----+
                     |   (プロファイリング停止)  |
                     +----------+-----------+
                                |
                                v
                     INTERNAL.aotProfileData
                        (AOT プロファイルデータ)
                                |
                                v
                     +-- saveProfile() ----+
                     |   Blob 作成 & DL     |
                     +----------+-----------+
                                |
                                v
                     "data.aotprofile" ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/mono/sample/wasm/browser-profile/wwwroot/index.html` | テンプレート | HTML エントリーポイント |
| main.js | `src/mono/sample/wasm/browser-profile/wwwroot/main.js` | ソース | JavaScript エントリーポイント、プロファイリング処理 |
| Program.cs | `src/mono/sample/wasm/browser-profile/Program.cs` | ソース | C# メインロジック、プロファイリング対象メソッド |
| dotnet.js | `_framework/dotnet.js` | ランタイム | .NET WebAssembly ランタイムローダー（ビルド時生成） |
